/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalSecurityPolicyName
implements ResourceName {
    private final String project;
    private final String securityPolicy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/securityPolicies/{securityPolicy}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalSecurityPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.securityPolicy = (String)Preconditions.checkNotNull((Object)builder.getSecurityPolicy());
    }

    public static ProjectGlobalSecurityPolicyName of(String project, String securityPolicy) {
        return ProjectGlobalSecurityPolicyName.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
    }

    public static String format(String project, String securityPolicy) {
        return ProjectGlobalSecurityPolicyName.of(project, securityPolicy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalSecurityPolicyName projectGlobalSecurityPolicyName = this;
            synchronized (projectGlobalSecurityPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"securityPolicy", (Object)this.securityPolicy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalSecurityPolicyName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalSecurityPolicyName>(){

            public ProjectGlobalSecurityPolicyName parse(String formattedString) {
                return ProjectGlobalSecurityPolicyName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalSecurityPolicyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalSecurityPolicyName.parse: formattedString not in valid format");
        return ProjectGlobalSecurityPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("securityPolicy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "securityPolicy", this.securityPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalSecurityPolicyName) {
            ProjectGlobalSecurityPolicyName that = (ProjectGlobalSecurityPolicyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.securityPolicy, that.getSecurityPolicy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.securityPolicy);
    }

    public static class Builder {
        private String project;
        private String securityPolicy;

        public String getProject() {
            return this.project;
        }

        public String getSecurityPolicy() {
            return this.securityPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSecurityPolicy(String securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalSecurityPolicyName projectGlobalSecurityPolicyName) {
            this.project = projectGlobalSecurityPolicyName.project;
            this.securityPolicy = projectGlobalSecurityPolicyName.securityPolicy;
        }

        public ProjectGlobalSecurityPolicyName build() {
            return new ProjectGlobalSecurityPolicyName(this);
        }
    }
}

