/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionVpnGatewayName
implements ResourceName {
    private final String project;
    private final String region;
    private final String vpnGateway;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/vpnGateways/{vpnGateway}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionVpnGatewayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.vpnGateway = (String)Preconditions.checkNotNull((Object)builder.getVpnGateway());
    }

    public static ProjectRegionVpnGatewayName of(String project, String region, String vpnGateway) {
        return ProjectRegionVpnGatewayName.newBuilder().setProject(project).setRegion(region).setVpnGateway(vpnGateway).build();
    }

    public static String format(String project, String region, String vpnGateway) {
        return ProjectRegionVpnGatewayName.of(project, region, vpnGateway).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVpnGateway() {
        return this.vpnGateway;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionVpnGatewayName projectRegionVpnGatewayName = this;
            synchronized (projectRegionVpnGatewayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"vpnGateway", (Object)this.vpnGateway);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionVpnGatewayName> newFactory() {
        return new ResourceNameFactory<ProjectRegionVpnGatewayName>(){

            public ProjectRegionVpnGatewayName parse(String formattedString) {
                return ProjectRegionVpnGatewayName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionVpnGatewayName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionVpnGatewayName.parse: formattedString not in valid format");
        return ProjectRegionVpnGatewayName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("vpnGateway"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "vpnGateway", this.vpnGateway});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionVpnGatewayName) {
            ProjectRegionVpnGatewayName that = (ProjectRegionVpnGatewayName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.vpnGateway, that.getVpnGateway());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.vpnGateway);
    }

    public static class Builder {
        private String project;
        private String region;
        private String vpnGateway;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getVpnGateway() {
            return this.vpnGateway;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setVpnGateway(String vpnGateway) {
            this.vpnGateway = vpnGateway;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionVpnGatewayName projectRegionVpnGatewayName) {
            this.project = projectRegionVpnGatewayName.project;
            this.region = projectRegionVpnGatewayName.region;
            this.vpnGateway = projectRegionVpnGatewayName.vpnGateway;
        }

        public ProjectRegionVpnGatewayName build() {
            return new ProjectRegionVpnGatewayName(this);
        }
    }
}

