/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.DeleteUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertUrlMapHttpRequest;
import com.google.cloud.compute.v1.InvalidateCacheUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchUrlMapHttpRequest;
import com.google.cloud.compute.v1.UpdateUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapClient;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsAggregatedList;
import com.google.cloud.compute.v1.UrlMapsScopedList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonUrlMapStub;
import com.google.cloud.compute.v1.stub.UrlMapStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class UrlMapStubSettings
extends StubSettings<UrlMapStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsSettings;
    private final UnaryCallSettings<DeleteUrlMapHttpRequest, Operation> deleteUrlMapSettings;
    private final UnaryCallSettings<GetUrlMapHttpRequest, UrlMap> getUrlMapSettings;
    private final UnaryCallSettings<InsertUrlMapHttpRequest, Operation> insertUrlMapSettings;
    private final UnaryCallSettings<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapSettings;
    private final PagedCallSettings<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsSettings;
    private final UnaryCallSettings<PatchUrlMapHttpRequest, Operation> patchUrlMapSettings;
    private final UnaryCallSettings<UpdateUrlMapHttpRequest, Operation> updateUrlMapSettings;
    private final UnaryCallSettings<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapSettings;
    private static final PagedListDescriptor<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList> AGGREGATED_LIST_URL_MAPS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListUrlMapsHttpRequest injectToken(AggregatedListUrlMapsHttpRequest payload, String token) {
            return AggregatedListUrlMapsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListUrlMapsHttpRequest injectPageSize(AggregatedListUrlMapsHttpRequest payload, int pageSize) {
            return AggregatedListUrlMapsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListUrlMapsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UrlMapsAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UrlMapsScopedList> extractResources(UrlMapsAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListUrlMapsHttpRequest, UrlMapList, UrlMap> LIST_URL_MAPS_PAGE_STR_DESC = new PagedListDescriptor<ListUrlMapsHttpRequest, UrlMapList, UrlMap>(){

        public String emptyToken() {
            return "";
        }

        public ListUrlMapsHttpRequest injectToken(ListUrlMapsHttpRequest payload, String token) {
            return ListUrlMapsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListUrlMapsHttpRequest injectPageSize(ListUrlMapsHttpRequest payload, int pageSize) {
            return ListUrlMapsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListUrlMapsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UrlMapList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UrlMap> extractResources(UrlMapList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse> AGGREGATED_LIST_URL_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse>(){

        public ApiFuture<UrlMapClient.AggregatedListUrlMapsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList> callable, AggregatedListUrlMapsHttpRequest request, ApiCallContext context, ApiFuture<UrlMapsAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_URL_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UrlMapClient.AggregatedListUrlMapsPagedResponse.createAsync((PageContext<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse> LIST_URL_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse>(){

        public ApiFuture<UrlMapClient.ListUrlMapsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUrlMapsHttpRequest, UrlMapList> callable, ListUrlMapsHttpRequest request, ApiCallContext context, ApiFuture<UrlMapList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_URL_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UrlMapClient.ListUrlMapsPagedResponse.createAsync((PageContext<ListUrlMapsHttpRequest, UrlMapList, UrlMap>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsSettings() {
        return this.aggregatedListUrlMapsSettings;
    }

    public UnaryCallSettings<DeleteUrlMapHttpRequest, Operation> deleteUrlMapSettings() {
        return this.deleteUrlMapSettings;
    }

    public UnaryCallSettings<GetUrlMapHttpRequest, UrlMap> getUrlMapSettings() {
        return this.getUrlMapSettings;
    }

    public UnaryCallSettings<InsertUrlMapHttpRequest, Operation> insertUrlMapSettings() {
        return this.insertUrlMapSettings;
    }

    public UnaryCallSettings<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapSettings() {
        return this.invalidateCacheUrlMapSettings;
    }

    public PagedCallSettings<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsSettings() {
        return this.listUrlMapsSettings;
    }

    public UnaryCallSettings<PatchUrlMapHttpRequest, Operation> patchUrlMapSettings() {
        return this.patchUrlMapSettings;
    }

    public UnaryCallSettings<UpdateUrlMapHttpRequest, Operation> updateUrlMapSettings() {
        return this.updateUrlMapSettings;
    }

    public UnaryCallSettings<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapSettings() {
        return this.validateUrlMapSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UrlMapStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonUrlMapStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UrlMapStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UrlMapStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UrlMapStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListUrlMapsSettings = settingsBuilder.aggregatedListUrlMapsSettings().build();
        this.deleteUrlMapSettings = settingsBuilder.deleteUrlMapSettings().build();
        this.getUrlMapSettings = settingsBuilder.getUrlMapSettings().build();
        this.insertUrlMapSettings = settingsBuilder.insertUrlMapSettings().build();
        this.invalidateCacheUrlMapSettings = settingsBuilder.invalidateCacheUrlMapSettings().build();
        this.listUrlMapsSettings = settingsBuilder.listUrlMapsSettings().build();
        this.patchUrlMapSettings = settingsBuilder.patchUrlMapSettings().build();
        this.updateUrlMapSettings = settingsBuilder.updateUrlMapSettings().build();
        this.validateUrlMapSettings = settingsBuilder.validateUrlMapSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UrlMapStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsSettings;
        private final UnaryCallSettings.Builder<DeleteUrlMapHttpRequest, Operation> deleteUrlMapSettings;
        private final UnaryCallSettings.Builder<GetUrlMapHttpRequest, UrlMap> getUrlMapSettings;
        private final UnaryCallSettings.Builder<InsertUrlMapHttpRequest, Operation> insertUrlMapSettings;
        private final UnaryCallSettings.Builder<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapSettings;
        private final PagedCallSettings.Builder<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsSettings;
        private final UnaryCallSettings.Builder<PatchUrlMapHttpRequest, Operation> patchUrlMapSettings;
        private final UnaryCallSettings.Builder<UpdateUrlMapHttpRequest, Operation> updateUrlMapSettings;
        private final UnaryCallSettings.Builder<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListUrlMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_URL_MAPS_PAGE_STR_FACT);
            this.deleteUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.invalidateCacheUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUrlMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_URL_MAPS_PAGE_STR_FACT);
            this.patchUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListUrlMapsSettings, this.deleteUrlMapSettings, this.getUrlMapSettings, this.insertUrlMapSettings, this.invalidateCacheUrlMapSettings, this.listUrlMapsSettings, this.patchUrlMapSettings, this.updateUrlMapSettings, this.validateUrlMapSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UrlMapStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UrlMapStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UrlMapStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(UrlMapStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListUrlMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.invalidateCacheUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listUrlMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.validateUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(UrlMapStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListUrlMapsSettings = settings.aggregatedListUrlMapsSettings.toBuilder();
            this.deleteUrlMapSettings = settings.deleteUrlMapSettings.toBuilder();
            this.getUrlMapSettings = settings.getUrlMapSettings.toBuilder();
            this.insertUrlMapSettings = settings.insertUrlMapSettings.toBuilder();
            this.invalidateCacheUrlMapSettings = settings.invalidateCacheUrlMapSettings.toBuilder();
            this.listUrlMapsSettings = settings.listUrlMapsSettings.toBuilder();
            this.patchUrlMapSettings = settings.patchUrlMapSettings.toBuilder();
            this.updateUrlMapSettings = settings.updateUrlMapSettings.toBuilder();
            this.validateUrlMapSettings = settings.validateUrlMapSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListUrlMapsSettings, this.deleteUrlMapSettings, this.getUrlMapSettings, this.insertUrlMapSettings, this.invalidateCacheUrlMapSettings, this.listUrlMapsSettings, this.patchUrlMapSettings, this.updateUrlMapSettings, this.validateUrlMapSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsSettings() {
            return this.aggregatedListUrlMapsSettings;
        }

        public UnaryCallSettings.Builder<DeleteUrlMapHttpRequest, Operation> deleteUrlMapSettings() {
            return this.deleteUrlMapSettings;
        }

        public UnaryCallSettings.Builder<GetUrlMapHttpRequest, UrlMap> getUrlMapSettings() {
            return this.getUrlMapSettings;
        }

        public UnaryCallSettings.Builder<InsertUrlMapHttpRequest, Operation> insertUrlMapSettings() {
            return this.insertUrlMapSettings;
        }

        public UnaryCallSettings.Builder<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapSettings() {
            return this.invalidateCacheUrlMapSettings;
        }

        public PagedCallSettings.Builder<ListUrlMapsHttpRequest, UrlMapList, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsSettings() {
            return this.listUrlMapsSettings;
        }

        public UnaryCallSettings.Builder<PatchUrlMapHttpRequest, Operation> patchUrlMapSettings() {
            return this.patchUrlMapSettings;
        }

        public UnaryCallSettings.Builder<UpdateUrlMapHttpRequest, Operation> updateUrlMapSettings() {
            return this.updateUrlMapSettings;
        }

        public UnaryCallSettings.Builder<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapSettings() {
            return this.validateUrlMapSettings;
        }

        public UrlMapStubSettings build() throws IOException {
            return new UrlMapStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

