/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListRegionUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.RegionUrlMapClient;
import com.google.cloud.compute.v1.UpdateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateRegionUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionUrlMapStub;
import com.google.cloud.compute.v1.stub.RegionUrlMapStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionUrlMapStubSettings
extends StubSettings<RegionUrlMapStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapSettings;
    private final UnaryCallSettings<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapSettings;
    private final UnaryCallSettings<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapSettings;
    private final PagedCallSettings<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsSettings;
    private final UnaryCallSettings<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapSettings;
    private final UnaryCallSettings<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapSettings;
    private final UnaryCallSettings<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapSettings;
    private static final PagedListDescriptor<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap> LIST_REGION_URL_MAPS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionUrlMapsHttpRequest injectToken(ListRegionUrlMapsHttpRequest payload, String token) {
            return ListRegionUrlMapsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionUrlMapsHttpRequest injectPageSize(ListRegionUrlMapsHttpRequest payload, int pageSize) {
            return ListRegionUrlMapsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionUrlMapsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UrlMapList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UrlMap> extractResources(UrlMapList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> LIST_REGION_URL_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse>(){

        public ApiFuture<RegionUrlMapClient.ListRegionUrlMapsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionUrlMapsHttpRequest, UrlMapList> callable, ListRegionUrlMapsHttpRequest request, ApiCallContext context, ApiFuture<UrlMapList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_URL_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionUrlMapClient.ListRegionUrlMapsPagedResponse.createAsync((PageContext<ListRegionUrlMapsHttpRequest, UrlMapList, UrlMap>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapSettings() {
        return this.deleteRegionUrlMapSettings;
    }

    public UnaryCallSettings<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapSettings() {
        return this.getRegionUrlMapSettings;
    }

    public UnaryCallSettings<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapSettings() {
        return this.insertRegionUrlMapSettings;
    }

    public PagedCallSettings<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsSettings() {
        return this.listRegionUrlMapsSettings;
    }

    public UnaryCallSettings<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapSettings() {
        return this.patchRegionUrlMapSettings;
    }

    public UnaryCallSettings<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapSettings() {
        return this.updateRegionUrlMapSettings;
    }

    public UnaryCallSettings<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapSettings() {
        return this.validateRegionUrlMapSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionUrlMapStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionUrlMapStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionUrlMapStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionUrlMapStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionUrlMapStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionUrlMapSettings = settingsBuilder.deleteRegionUrlMapSettings().build();
        this.getRegionUrlMapSettings = settingsBuilder.getRegionUrlMapSettings().build();
        this.insertRegionUrlMapSettings = settingsBuilder.insertRegionUrlMapSettings().build();
        this.listRegionUrlMapsSettings = settingsBuilder.listRegionUrlMapsSettings().build();
        this.patchRegionUrlMapSettings = settingsBuilder.patchRegionUrlMapSettings().build();
        this.updateRegionUrlMapSettings = settingsBuilder.updateRegionUrlMapSettings().build();
        this.validateRegionUrlMapSettings = settingsBuilder.validateRegionUrlMapSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionUrlMapStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapSettings;
        private final UnaryCallSettings.Builder<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapSettings;
        private final UnaryCallSettings.Builder<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapSettings;
        private final PagedCallSettings.Builder<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsSettings;
        private final UnaryCallSettings.Builder<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapSettings;
        private final UnaryCallSettings.Builder<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapSettings;
        private final UnaryCallSettings.Builder<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionUrlMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_URL_MAPS_PAGE_STR_FACT);
            this.patchRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.validateRegionUrlMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionUrlMapSettings, this.getRegionUrlMapSettings, this.insertRegionUrlMapSettings, this.listRegionUrlMapsSettings, this.patchRegionUrlMapSettings, this.updateRegionUrlMapSettings, this.validateRegionUrlMapSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionUrlMapStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionUrlMapStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionUrlMapStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionUrlMapStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionUrlMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.validateRegionUrlMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionUrlMapStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionUrlMapSettings = settings.deleteRegionUrlMapSettings.toBuilder();
            this.getRegionUrlMapSettings = settings.getRegionUrlMapSettings.toBuilder();
            this.insertRegionUrlMapSettings = settings.insertRegionUrlMapSettings.toBuilder();
            this.listRegionUrlMapsSettings = settings.listRegionUrlMapsSettings.toBuilder();
            this.patchRegionUrlMapSettings = settings.patchRegionUrlMapSettings.toBuilder();
            this.updateRegionUrlMapSettings = settings.updateRegionUrlMapSettings.toBuilder();
            this.validateRegionUrlMapSettings = settings.validateRegionUrlMapSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionUrlMapSettings, this.getRegionUrlMapSettings, this.insertRegionUrlMapSettings, this.listRegionUrlMapsSettings, this.patchRegionUrlMapSettings, this.updateRegionUrlMapSettings, this.validateRegionUrlMapSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionUrlMapHttpRequest, Operation> deleteRegionUrlMapSettings() {
            return this.deleteRegionUrlMapSettings;
        }

        public UnaryCallSettings.Builder<GetRegionUrlMapHttpRequest, UrlMap> getRegionUrlMapSettings() {
            return this.getRegionUrlMapSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionUrlMapHttpRequest, Operation> insertRegionUrlMapSettings() {
            return this.insertRegionUrlMapSettings;
        }

        public PagedCallSettings.Builder<ListRegionUrlMapsHttpRequest, UrlMapList, RegionUrlMapClient.ListRegionUrlMapsPagedResponse> listRegionUrlMapsSettings() {
            return this.listRegionUrlMapsSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionUrlMapHttpRequest, Operation> patchRegionUrlMapSettings() {
            return this.patchRegionUrlMapSettings;
        }

        public UnaryCallSettings.Builder<UpdateRegionUrlMapHttpRequest, Operation> updateRegionUrlMapSettings() {
            return this.updateRegionUrlMapSettings;
        }

        public UnaryCallSettings.Builder<ValidateRegionUrlMapHttpRequest, UrlMapsValidateResponse> validateRegionUrlMapSettings() {
            return this.validateRegionUrlMapSettings;
        }

        public RegionUrlMapStubSettings build() throws IOException {
            return new RegionUrlMapStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

