/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.AggregatedListBackendServicesHttpRequest;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceAggregatedList;
import com.google.cloud.compute.v1.BackendServiceClient;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServicesScopedList;
import com.google.cloud.compute.v1.DeleteBackendServiceHttpRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetBackendServiceHttpRequest;
import com.google.cloud.compute.v1.GetHealthBackendServiceHttpRequest;
import com.google.cloud.compute.v1.InsertBackendServiceHttpRequest;
import com.google.cloud.compute.v1.ListBackendServicesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendServiceHttpRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyBackendServiceHttpRequest;
import com.google.cloud.compute.v1.UpdateBackendServiceHttpRequest;
import com.google.cloud.compute.v1.stub.BackendServiceStub;
import com.google.cloud.compute.v1.stub.HttpJsonBackendServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BackendServiceStubSettings
extends StubSettings<BackendServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AddSignedUrlKeyBackendServiceHttpRequest, Operation> addSignedUrlKeyBackendServiceSettings;
    private final PagedCallSettings<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse> aggregatedListBackendServicesSettings;
    private final UnaryCallSettings<DeleteBackendServiceHttpRequest, Operation> deleteBackendServiceSettings;
    private final UnaryCallSettings<DeleteSignedUrlKeyBackendServiceHttpRequest, Operation> deleteSignedUrlKeyBackendServiceSettings;
    private final UnaryCallSettings<GetBackendServiceHttpRequest, BackendService> getBackendServiceSettings;
    private final UnaryCallSettings<GetHealthBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthBackendServiceSettings;
    private final UnaryCallSettings<InsertBackendServiceHttpRequest, Operation> insertBackendServiceSettings;
    private final PagedCallSettings<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse> listBackendServicesSettings;
    private final UnaryCallSettings<PatchBackendServiceHttpRequest, Operation> patchBackendServiceSettings;
    private final UnaryCallSettings<SetSecurityPolicyBackendServiceHttpRequest, Operation> setSecurityPolicyBackendServiceSettings;
    private final UnaryCallSettings<UpdateBackendServiceHttpRequest, Operation> updateBackendServiceSettings;
    private static final PagedListDescriptor<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList> AGGREGATED_LIST_BACKEND_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListBackendServicesHttpRequest injectToken(AggregatedListBackendServicesHttpRequest payload, String token) {
            return AggregatedListBackendServicesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListBackendServicesHttpRequest injectPageSize(AggregatedListBackendServicesHttpRequest payload, int pageSize) {
            return AggregatedListBackendServicesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListBackendServicesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendServicesScopedList> extractResources(BackendServiceAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListBackendServicesHttpRequest, BackendServiceList, BackendService> LIST_BACKEND_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListBackendServicesHttpRequest, BackendServiceList, BackendService>(){

        public String emptyToken() {
            return "";
        }

        public ListBackendServicesHttpRequest injectToken(ListBackendServicesHttpRequest payload, String token) {
            return ListBackendServicesHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListBackendServicesHttpRequest injectPageSize(ListBackendServicesHttpRequest payload, int pageSize) {
            return ListBackendServicesHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListBackendServicesHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendServiceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendService> extractResources(BackendServiceList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse> AGGREGATED_LIST_BACKEND_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse>(){

        public ApiFuture<BackendServiceClient.AggregatedListBackendServicesPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList> callable, AggregatedListBackendServicesHttpRequest request, ApiCallContext context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_BACKEND_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendServiceClient.AggregatedListBackendServicesPagedResponse.createAsync((PageContext<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServicesScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse> LIST_BACKEND_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse>(){

        public ApiFuture<BackendServiceClient.ListBackendServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackendServicesHttpRequest, BackendServiceList> callable, ListBackendServicesHttpRequest request, ApiCallContext context, ApiFuture<BackendServiceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKEND_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendServiceClient.ListBackendServicesPagedResponse.createAsync((PageContext<ListBackendServicesHttpRequest, BackendServiceList, BackendService>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddSignedUrlKeyBackendServiceHttpRequest, Operation> addSignedUrlKeyBackendServiceSettings() {
        return this.addSignedUrlKeyBackendServiceSettings;
    }

    public PagedCallSettings<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse> aggregatedListBackendServicesSettings() {
        return this.aggregatedListBackendServicesSettings;
    }

    public UnaryCallSettings<DeleteBackendServiceHttpRequest, Operation> deleteBackendServiceSettings() {
        return this.deleteBackendServiceSettings;
    }

    public UnaryCallSettings<DeleteSignedUrlKeyBackendServiceHttpRequest, Operation> deleteSignedUrlKeyBackendServiceSettings() {
        return this.deleteSignedUrlKeyBackendServiceSettings;
    }

    public UnaryCallSettings<GetBackendServiceHttpRequest, BackendService> getBackendServiceSettings() {
        return this.getBackendServiceSettings;
    }

    public UnaryCallSettings<GetHealthBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthBackendServiceSettings() {
        return this.getHealthBackendServiceSettings;
    }

    public UnaryCallSettings<InsertBackendServiceHttpRequest, Operation> insertBackendServiceSettings() {
        return this.insertBackendServiceSettings;
    }

    public PagedCallSettings<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse> listBackendServicesSettings() {
        return this.listBackendServicesSettings;
    }

    public UnaryCallSettings<PatchBackendServiceHttpRequest, Operation> patchBackendServiceSettings() {
        return this.patchBackendServiceSettings;
    }

    public UnaryCallSettings<SetSecurityPolicyBackendServiceHttpRequest, Operation> setSecurityPolicyBackendServiceSettings() {
        return this.setSecurityPolicyBackendServiceSettings;
    }

    public UnaryCallSettings<UpdateBackendServiceHttpRequest, Operation> updateBackendServiceSettings() {
        return this.updateBackendServiceSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackendServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackendServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackendServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackendServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addSignedUrlKeyBackendServiceSettings = settingsBuilder.addSignedUrlKeyBackendServiceSettings().build();
        this.aggregatedListBackendServicesSettings = settingsBuilder.aggregatedListBackendServicesSettings().build();
        this.deleteBackendServiceSettings = settingsBuilder.deleteBackendServiceSettings().build();
        this.deleteSignedUrlKeyBackendServiceSettings = settingsBuilder.deleteSignedUrlKeyBackendServiceSettings().build();
        this.getBackendServiceSettings = settingsBuilder.getBackendServiceSettings().build();
        this.getHealthBackendServiceSettings = settingsBuilder.getHealthBackendServiceSettings().build();
        this.insertBackendServiceSettings = settingsBuilder.insertBackendServiceSettings().build();
        this.listBackendServicesSettings = settingsBuilder.listBackendServicesSettings().build();
        this.patchBackendServiceSettings = settingsBuilder.patchBackendServiceSettings().build();
        this.setSecurityPolicyBackendServiceSettings = settingsBuilder.setSecurityPolicyBackendServiceSettings().build();
        this.updateBackendServiceSettings = settingsBuilder.updateBackendServiceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackendServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddSignedUrlKeyBackendServiceHttpRequest, Operation> addSignedUrlKeyBackendServiceSettings;
        private final PagedCallSettings.Builder<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse> aggregatedListBackendServicesSettings;
        private final UnaryCallSettings.Builder<DeleteBackendServiceHttpRequest, Operation> deleteBackendServiceSettings;
        private final UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendServiceHttpRequest, Operation> deleteSignedUrlKeyBackendServiceSettings;
        private final UnaryCallSettings.Builder<GetBackendServiceHttpRequest, BackendService> getBackendServiceSettings;
        private final UnaryCallSettings.Builder<GetHealthBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthBackendServiceSettings;
        private final UnaryCallSettings.Builder<InsertBackendServiceHttpRequest, Operation> insertBackendServiceSettings;
        private final PagedCallSettings.Builder<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse> listBackendServicesSettings;
        private final UnaryCallSettings.Builder<PatchBackendServiceHttpRequest, Operation> patchBackendServiceSettings;
        private final UnaryCallSettings.Builder<SetSecurityPolicyBackendServiceHttpRequest, Operation> setSecurityPolicyBackendServiceSettings;
        private final UnaryCallSettings.Builder<UpdateBackendServiceHttpRequest, Operation> updateBackendServiceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addSignedUrlKeyBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListBackendServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_BACKEND_SERVICES_PAGE_STR_FACT);
            this.deleteBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSignedUrlKeyBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getHealthBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBackendServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKEND_SERVICES_PAGE_STR_FACT);
            this.patchBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicyBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackendServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeyBackendServiceSettings, this.aggregatedListBackendServicesSettings, this.deleteBackendServiceSettings, this.deleteSignedUrlKeyBackendServiceSettings, this.getBackendServiceSettings, this.getHealthBackendServiceSettings, this.insertBackendServiceSettings, this.listBackendServicesSettings, this.patchBackendServiceSettings, this.setSecurityPolicyBackendServiceSettings, this.updateBackendServiceSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackendServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackendServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackendServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BackendServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addSignedUrlKeyBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListBackendServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSignedUrlKeyBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getHealthBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listBackendServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setSecurityPolicyBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateBackendServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(BackendServiceStubSettings settings) {
            super((StubSettings)settings);
            this.addSignedUrlKeyBackendServiceSettings = settings.addSignedUrlKeyBackendServiceSettings.toBuilder();
            this.aggregatedListBackendServicesSettings = settings.aggregatedListBackendServicesSettings.toBuilder();
            this.deleteBackendServiceSettings = settings.deleteBackendServiceSettings.toBuilder();
            this.deleteSignedUrlKeyBackendServiceSettings = settings.deleteSignedUrlKeyBackendServiceSettings.toBuilder();
            this.getBackendServiceSettings = settings.getBackendServiceSettings.toBuilder();
            this.getHealthBackendServiceSettings = settings.getHealthBackendServiceSettings.toBuilder();
            this.insertBackendServiceSettings = settings.insertBackendServiceSettings.toBuilder();
            this.listBackendServicesSettings = settings.listBackendServicesSettings.toBuilder();
            this.patchBackendServiceSettings = settings.patchBackendServiceSettings.toBuilder();
            this.setSecurityPolicyBackendServiceSettings = settings.setSecurityPolicyBackendServiceSettings.toBuilder();
            this.updateBackendServiceSettings = settings.updateBackendServiceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeyBackendServiceSettings, this.aggregatedListBackendServicesSettings, this.deleteBackendServiceSettings, this.deleteSignedUrlKeyBackendServiceSettings, this.getBackendServiceSettings, this.getHealthBackendServiceSettings, this.insertBackendServiceSettings, this.listBackendServicesSettings, this.patchBackendServiceSettings, this.setSecurityPolicyBackendServiceSettings, this.updateBackendServiceSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddSignedUrlKeyBackendServiceHttpRequest, Operation> addSignedUrlKeyBackendServiceSettings() {
            return this.addSignedUrlKeyBackendServiceSettings;
        }

        public PagedCallSettings.Builder<AggregatedListBackendServicesHttpRequest, BackendServiceAggregatedList, BackendServiceClient.AggregatedListBackendServicesPagedResponse> aggregatedListBackendServicesSettings() {
            return this.aggregatedListBackendServicesSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackendServiceHttpRequest, Operation> deleteBackendServiceSettings() {
            return this.deleteBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendServiceHttpRequest, Operation> deleteSignedUrlKeyBackendServiceSettings() {
            return this.deleteSignedUrlKeyBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<GetBackendServiceHttpRequest, BackendService> getBackendServiceSettings() {
            return this.getBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<GetHealthBackendServiceHttpRequest, BackendServiceGroupHealth> getHealthBackendServiceSettings() {
            return this.getHealthBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<InsertBackendServiceHttpRequest, Operation> insertBackendServiceSettings() {
            return this.insertBackendServiceSettings;
        }

        public PagedCallSettings.Builder<ListBackendServicesHttpRequest, BackendServiceList, BackendServiceClient.ListBackendServicesPagedResponse> listBackendServicesSettings() {
            return this.listBackendServicesSettings;
        }

        public UnaryCallSettings.Builder<PatchBackendServiceHttpRequest, Operation> patchBackendServiceSettings() {
            return this.patchBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<SetSecurityPolicyBackendServiceHttpRequest, Operation> setSecurityPolicyBackendServiceSettings() {
            return this.setSecurityPolicyBackendServiceSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackendServiceHttpRequest, Operation> updateBackendServiceSettings() {
            return this.updateBackendServiceSettings;
        }

        public BackendServiceStubSettings build() throws IOException {
            return new BackendServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

