/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.VpnGatewayVpnGatewayInterface;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class VpnGateway
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final String id;
    private final String kind;
    private final String labelFingerprint;
    private final Map<String, String> labels;
    private final String name;
    private final String network;
    private final String region;
    private final String selfLink;
    private final List<VpnGatewayVpnGatewayInterface> vpnInterfaces;
    private static final VpnGateway DEFAULT_INSTANCE = new VpnGateway();

    private VpnGateway() {
        this.creationTimestamp = null;
        this.description = null;
        this.id = null;
        this.kind = null;
        this.labelFingerprint = null;
        this.labels = null;
        this.name = null;
        this.network = null;
        this.region = null;
        this.selfLink = null;
        this.vpnInterfaces = null;
    }

    private VpnGateway(String creationTimestamp, String description, String id, String kind, String labelFingerprint, Map<String, String> labels, String name, String network, String region, String selfLink, List<VpnGatewayVpnGatewayInterface> vpnInterfaces) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.id = id;
        this.kind = kind;
        this.labelFingerprint = labelFingerprint;
        this.labels = labels;
        this.name = name;
        this.network = network;
        this.region = region;
        this.selfLink = selfLink;
        this.vpnInterfaces = vpnInterfaces;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("labelFingerprint".equals(fieldName)) {
            return this.labelFingerprint;
        }
        if ("labels".equals(fieldName)) {
            return this.labels;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("vpnInterfaces".equals(fieldName)) {
            return this.vpnInterfaces;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getLabelFingerprint() {
        return this.labelFingerprint;
    }

    public Map<String, String> getLabelsMap() {
        return this.labels;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public List<VpnGatewayVpnGatewayInterface> getVpnInterfacesList() {
        return this.vpnInterfaces;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(VpnGateway prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static VpnGateway getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "VpnGateway{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", id=" + this.id + ", kind=" + this.kind + ", labelFingerprint=" + this.labelFingerprint + ", labels=" + this.labels + ", name=" + this.name + ", network=" + this.network + ", region=" + this.region + ", selfLink=" + this.selfLink + ", vpnInterfaces=" + this.vpnInterfaces + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VpnGateway) {
            VpnGateway that = (VpnGateway)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.labelFingerprint, that.getLabelFingerprint()) && Objects.equals(this.labels, that.getLabelsMap()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.vpnInterfaces, that.getVpnInterfacesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.id, this.kind, this.labelFingerprint, this.labels, this.name, this.network, this.region, this.selfLink, this.vpnInterfaces);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private String id;
        private String kind;
        private String labelFingerprint;
        private Map<String, String> labels;
        private String name;
        private String network;
        private String region;
        private String selfLink;
        private List<VpnGatewayVpnGatewayInterface> vpnInterfaces;

        Builder() {
        }

        public Builder mergeFrom(VpnGateway other) {
            if (other == VpnGateway.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getLabelFingerprint() != null) {
                this.labelFingerprint = other.labelFingerprint;
            }
            if (other.getLabelsMap() != null) {
                this.labels = other.labels;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getVpnInterfacesList() != null) {
                this.vpnInterfaces = other.vpnInterfaces;
            }
            return this;
        }

        Builder(VpnGateway source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.id = source.id;
            this.kind = source.kind;
            this.labelFingerprint = source.labelFingerprint;
            this.labels = source.labels;
            this.name = source.name;
            this.network = source.network;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.vpnInterfaces = source.vpnInterfaces;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getLabelFingerprint() {
            return this.labelFingerprint;
        }

        public Builder setLabelFingerprint(String labelFingerprint) {
            this.labelFingerprint = labelFingerprint;
            return this;
        }

        public Map<String, String> getLabelsMap() {
            return this.labels;
        }

        public Builder putAllLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public List<VpnGatewayVpnGatewayInterface> getVpnInterfacesList() {
            return this.vpnInterfaces;
        }

        public Builder addAllVpnInterfaces(List<VpnGatewayVpnGatewayInterface> vpnInterfaces) {
            if (this.vpnInterfaces == null) {
                this.vpnInterfaces = new LinkedList<VpnGatewayVpnGatewayInterface>();
            }
            this.vpnInterfaces.addAll(vpnInterfaces);
            return this;
        }

        public Builder addVpnInterfaces(VpnGatewayVpnGatewayInterface vpnInterfaces) {
            if (this.vpnInterfaces == null) {
                this.vpnInterfaces = new LinkedList<VpnGatewayVpnGatewayInterface>();
            }
            this.vpnInterfaces.add(vpnInterfaces);
            return this;
        }

        public VpnGateway build() {
            return new VpnGateway(this.creationTimestamp, this.description, this.id, this.kind, this.labelFingerprint, this.labels, this.name, this.network, this.region, this.selfLink, this.vpnInterfaces);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setLabelFingerprint(this.labelFingerprint);
            newBuilder.putAllLabels(this.labels);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.addAllVpnInterfaces(this.vpnInterfaces);
            return newBuilder;
        }
    }
}

