/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.DeleteSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.GetRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.GetSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.InsertSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest;
import com.google.cloud.compute.v1.ListSecurityPoliciesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.PatchSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalSecurityPolicyName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.RemoveRuleSecurityPolicyHttpRequest;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.SecurityPolicySettings;
import com.google.cloud.compute.v1.stub.SecurityPolicyStub;
import com.google.cloud.compute.v1.stub.SecurityPolicyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SecurityPolicyClient
implements BackgroundResource {
    private final SecurityPolicySettings settings;
    private final SecurityPolicyStub stub;

    public static final SecurityPolicyClient create() throws IOException {
        return SecurityPolicyClient.create(SecurityPolicySettings.newBuilder().build());
    }

    public static final SecurityPolicyClient create(SecurityPolicySettings settings) throws IOException {
        return new SecurityPolicyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SecurityPolicyClient create(SecurityPolicyStub stub) {
        return new SecurityPolicyClient(stub);
    }

    protected SecurityPolicyClient(SecurityPolicySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityPolicyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SecurityPolicyClient(SecurityPolicyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecurityPolicySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityPolicyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation addRuleSecurityPolicy(ProjectGlobalSecurityPolicyName securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleSecurityPolicyHttpRequest request = AddRuleSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation addRuleSecurityPolicy(String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleSecurityPolicyHttpRequest request = AddRuleSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation addRuleSecurityPolicy(AddRuleSecurityPolicyHttpRequest request) {
        return (Operation)this.addRuleSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<AddRuleSecurityPolicyHttpRequest, Operation> addRuleSecurityPolicyCallable() {
        return this.stub.addRuleSecurityPolicyCallable();
    }

    @BetaApi
    public final Operation deleteSecurityPolicy(ProjectGlobalSecurityPolicyName securityPolicy) {
        DeleteSecurityPolicyHttpRequest request = DeleteSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).build();
        return this.deleteSecurityPolicy(request);
    }

    @BetaApi
    public final Operation deleteSecurityPolicy(String securityPolicy) {
        DeleteSecurityPolicyHttpRequest request = DeleteSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.deleteSecurityPolicy(request);
    }

    @BetaApi
    public final Operation deleteSecurityPolicy(DeleteSecurityPolicyHttpRequest request) {
        return (Operation)this.deleteSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteSecurityPolicyHttpRequest, Operation> deleteSecurityPolicyCallable() {
        return this.stub.deleteSecurityPolicyCallable();
    }

    @BetaApi
    public final SecurityPolicy getSecurityPolicy(ProjectGlobalSecurityPolicyName securityPolicy) {
        GetSecurityPolicyHttpRequest request = GetSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).build();
        return this.getSecurityPolicy(request);
    }

    @BetaApi
    public final SecurityPolicy getSecurityPolicy(String securityPolicy) {
        GetSecurityPolicyHttpRequest request = GetSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy).build();
        return this.getSecurityPolicy(request);
    }

    @BetaApi
    public final SecurityPolicy getSecurityPolicy(GetSecurityPolicyHttpRequest request) {
        return (SecurityPolicy)this.getSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetSecurityPolicyHttpRequest, SecurityPolicy> getSecurityPolicyCallable() {
        return this.stub.getSecurityPolicyCallable();
    }

    @BetaApi
    public final SecurityPolicyRule getRuleSecurityPolicy(Integer priority, ProjectGlobalSecurityPolicyName securityPolicy) {
        GetRuleSecurityPolicyHttpRequest request = GetRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).build();
        return this.getRuleSecurityPolicy(request);
    }

    @BetaApi
    public final SecurityPolicyRule getRuleSecurityPolicy(Integer priority, String securityPolicy) {
        GetRuleSecurityPolicyHttpRequest request = GetRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy).build();
        return this.getRuleSecurityPolicy(request);
    }

    @BetaApi
    public final SecurityPolicyRule getRuleSecurityPolicy(GetRuleSecurityPolicyHttpRequest request) {
        return (SecurityPolicyRule)this.getRuleSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRuleSecurityPolicyHttpRequest, SecurityPolicyRule> getRuleSecurityPolicyCallable() {
        return this.stub.getRuleSecurityPolicyCallable();
    }

    @BetaApi
    public final Operation insertSecurityPolicy(ProjectName project, SecurityPolicy securityPolicyResource) {
        InsertSecurityPolicyHttpRequest request = InsertSecurityPolicyHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertSecurityPolicy(request);
    }

    @BetaApi
    public final Operation insertSecurityPolicy(String project, SecurityPolicy securityPolicyResource) {
        InsertSecurityPolicyHttpRequest request = InsertSecurityPolicyHttpRequest.newBuilder().setProject(project).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertSecurityPolicy(request);
    }

    @BetaApi
    public final Operation insertSecurityPolicy(InsertSecurityPolicyHttpRequest request) {
        return (Operation)this.insertSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertSecurityPolicyHttpRequest, Operation> insertSecurityPolicyCallable() {
        return this.stub.insertSecurityPolicyCallable();
    }

    @BetaApi
    public final ListSecurityPoliciesPagedResponse listSecurityPolicies(ProjectName project) {
        ListSecurityPoliciesHttpRequest request = ListSecurityPoliciesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listSecurityPolicies(request);
    }

    @BetaApi
    public final ListSecurityPoliciesPagedResponse listSecurityPolicies(String project) {
        ListSecurityPoliciesHttpRequest request = ListSecurityPoliciesHttpRequest.newBuilder().setProject(project).build();
        return this.listSecurityPolicies(request);
    }

    @BetaApi
    public final ListSecurityPoliciesPagedResponse listSecurityPolicies(ListSecurityPoliciesHttpRequest request) {
        return (ListSecurityPoliciesPagedResponse)((Object)this.listSecurityPoliciesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListSecurityPoliciesHttpRequest, ListSecurityPoliciesPagedResponse> listSecurityPoliciesPagedCallable() {
        return this.stub.listSecurityPoliciesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListSecurityPoliciesHttpRequest, SecurityPolicyList> listSecurityPoliciesCallable() {
        return this.stub.listSecurityPoliciesCallable();
    }

    @BetaApi
    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSetsSecurityPolicies(ProjectName project) {
        ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest request = ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listPreconfiguredExpressionSetsSecurityPolicies(request);
    }

    @BetaApi
    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSetsSecurityPolicies(String project) {
        ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest request = ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest.newBuilder().setProject(project).build();
        return this.listPreconfiguredExpressionSetsSecurityPolicies(request);
    }

    @BetaApi
    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSetsSecurityPolicies(ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest request) {
        return (SecurityPoliciesListPreconfiguredExpressionSetsResponse)this.listPreconfiguredExpressionSetsSecurityPoliciesCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<ListPreconfiguredExpressionSetsSecurityPoliciesHttpRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSecurityPoliciesCallable() {
        return this.stub.listPreconfiguredExpressionSetsSecurityPoliciesCallable();
    }

    @BetaApi
    public final Operation patchSecurityPolicy(ProjectGlobalSecurityPolicyName securityPolicy, SecurityPolicy securityPolicyResource, List<String> fieldMask) {
        PatchSecurityPolicyHttpRequest request = PatchSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).setSecurityPolicyResource(securityPolicyResource).addAllFieldMask(fieldMask).build();
        return this.patchSecurityPolicy(request);
    }

    @BetaApi
    public final Operation patchSecurityPolicy(String securityPolicy, SecurityPolicy securityPolicyResource, List<String> fieldMask) {
        PatchSecurityPolicyHttpRequest request = PatchSecurityPolicyHttpRequest.newBuilder().setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).addAllFieldMask(fieldMask).build();
        return this.patchSecurityPolicy(request);
    }

    @BetaApi
    public final Operation patchSecurityPolicy(PatchSecurityPolicyHttpRequest request) {
        return (Operation)this.patchSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchSecurityPolicyHttpRequest, Operation> patchSecurityPolicyCallable() {
        return this.stub.patchSecurityPolicyCallable();
    }

    @BetaApi
    public final Operation patchRuleSecurityPolicy(Integer priority, ProjectGlobalSecurityPolicyName securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleSecurityPolicyHttpRequest request = PatchRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation patchRuleSecurityPolicy(Integer priority, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleSecurityPolicyHttpRequest request = PatchRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation patchRuleSecurityPolicy(PatchRuleSecurityPolicyHttpRequest request) {
        return (Operation)this.patchRuleSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<PatchRuleSecurityPolicyHttpRequest, Operation> patchRuleSecurityPolicyCallable() {
        return this.stub.patchRuleSecurityPolicyCallable();
    }

    @BetaApi
    public final Operation removeRuleSecurityPolicy(Integer priority, ProjectGlobalSecurityPolicyName securityPolicy) {
        RemoveRuleSecurityPolicyHttpRequest request = RemoveRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy == null ? null : securityPolicy.toString()).build();
        return this.removeRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation removeRuleSecurityPolicy(Integer priority, String securityPolicy) {
        RemoveRuleSecurityPolicyHttpRequest request = RemoveRuleSecurityPolicyHttpRequest.newBuilder().setPriority(priority).setSecurityPolicy(securityPolicy).build();
        return this.removeRuleSecurityPolicy(request);
    }

    @BetaApi
    public final Operation removeRuleSecurityPolicy(RemoveRuleSecurityPolicyHttpRequest request) {
        return (Operation)this.removeRuleSecurityPolicyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<RemoveRuleSecurityPolicyHttpRequest, Operation> removeRuleSecurityPolicyCallable() {
        return this.stub.removeRuleSecurityPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSecurityPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy, ListSecurityPoliciesPage, ListSecurityPoliciesFixedSizeCollection> {
        private ListSecurityPoliciesFixedSizeCollection(List<ListSecurityPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSecurityPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListSecurityPoliciesFixedSizeCollection(null, 0);
        }

        protected ListSecurityPoliciesFixedSizeCollection createCollection(List<ListSecurityPoliciesPage> pages, int collectionSize) {
            return new ListSecurityPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSecurityPoliciesPage
    extends AbstractPage<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy, ListSecurityPoliciesPage> {
        private ListSecurityPoliciesPage(PageContext<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListSecurityPoliciesPage createEmptyPage() {
            return new ListSecurityPoliciesPage(null, null);
        }

        protected ListSecurityPoliciesPage createPage(PageContext<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListSecurityPoliciesPage(context, response);
        }

        public ApiFuture<ListSecurityPoliciesPage> createPageAsync(PageContext<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSecurityPoliciesPagedResponse
    extends AbstractPagedListResponse<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy, ListSecurityPoliciesPage, ListSecurityPoliciesFixedSizeCollection> {
        public static ApiFuture<ListSecurityPoliciesPagedResponse> createAsync(PageContext<ListSecurityPoliciesHttpRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListSecurityPoliciesPage> futurePage = ListSecurityPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSecurityPoliciesPage, ListSecurityPoliciesPagedResponse>(){

                public ListSecurityPoliciesPagedResponse apply(ListSecurityPoliciesPage input) {
                    return new ListSecurityPoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSecurityPoliciesPagedResponse(ListSecurityPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSecurityPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

