/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SSLHealthCheck
implements ApiMessage {
    private final Integer port;
    private final String portName;
    private final String portSpecification;
    private final String proxyHeader;
    private final String request;
    private final String response;
    private static final SSLHealthCheck DEFAULT_INSTANCE = new SSLHealthCheck();

    private SSLHealthCheck() {
        this.port = null;
        this.portName = null;
        this.portSpecification = null;
        this.proxyHeader = null;
        this.request = null;
        this.response = null;
    }

    private SSLHealthCheck(Integer port, String portName, String portSpecification, String proxyHeader, String request, String response) {
        this.port = port;
        this.portName = portName;
        this.portSpecification = portSpecification;
        this.proxyHeader = proxyHeader;
        this.request = request;
        this.response = response;
    }

    public Object getFieldValue(String fieldName) {
        if ("port".equals(fieldName)) {
            return this.port;
        }
        if ("portName".equals(fieldName)) {
            return this.portName;
        }
        if ("portSpecification".equals(fieldName)) {
            return this.portSpecification;
        }
        if ("proxyHeader".equals(fieldName)) {
            return this.proxyHeader;
        }
        if ("request".equals(fieldName)) {
            return this.request;
        }
        if ("response".equals(fieldName)) {
            return this.response;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getPortSpecification() {
        return this.portSpecification;
    }

    public String getProxyHeader() {
        return this.proxyHeader;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SSLHealthCheck prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SSLHealthCheck getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SSLHealthCheck{port=" + this.port + ", portName=" + this.portName + ", portSpecification=" + this.portSpecification + ", proxyHeader=" + this.proxyHeader + ", request=" + this.request + ", response=" + this.response + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SSLHealthCheck) {
            SSLHealthCheck that = (SSLHealthCheck)o;
            return Objects.equals(this.port, that.getPort()) && Objects.equals(this.portName, that.getPortName()) && Objects.equals(this.portSpecification, that.getPortSpecification()) && Objects.equals(this.proxyHeader, that.getProxyHeader()) && Objects.equals(this.request, that.getRequest()) && Objects.equals(this.response, that.getResponse());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.port, this.portName, this.portSpecification, this.proxyHeader, this.request, this.response);
    }

    public static class Builder {
        private Integer port;
        private String portName;
        private String portSpecification;
        private String proxyHeader;
        private String request;
        private String response;

        Builder() {
        }

        public Builder mergeFrom(SSLHealthCheck other) {
            if (other == SSLHealthCheck.getDefaultInstance()) {
                return this;
            }
            if (other.getPort() != null) {
                this.port = other.port;
            }
            if (other.getPortName() != null) {
                this.portName = other.portName;
            }
            if (other.getPortSpecification() != null) {
                this.portSpecification = other.portSpecification;
            }
            if (other.getProxyHeader() != null) {
                this.proxyHeader = other.proxyHeader;
            }
            if (other.getRequest() != null) {
                this.request = other.request;
            }
            if (other.getResponse() != null) {
                this.response = other.response;
            }
            return this;
        }

        Builder(SSLHealthCheck source) {
            this.port = source.port;
            this.portName = source.portName;
            this.portSpecification = source.portSpecification;
            this.proxyHeader = source.proxyHeader;
            this.request = source.request;
            this.response = source.response;
        }

        public Integer getPort() {
            return this.port;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public String getPortName() {
            return this.portName;
        }

        public Builder setPortName(String portName) {
            this.portName = portName;
            return this;
        }

        public String getPortSpecification() {
            return this.portSpecification;
        }

        public Builder setPortSpecification(String portSpecification) {
            this.portSpecification = portSpecification;
            return this;
        }

        public String getProxyHeader() {
            return this.proxyHeader;
        }

        public Builder setProxyHeader(String proxyHeader) {
            this.proxyHeader = proxyHeader;
            return this;
        }

        public String getRequest() {
            return this.request;
        }

        public Builder setRequest(String request) {
            this.request = request;
            return this;
        }

        public String getResponse() {
            return this.response;
        }

        public Builder setResponse(String response) {
            this.response = response;
            return this;
        }

        public SSLHealthCheck build() {
            return new SSLHealthCheck(this.port, this.portName, this.portSpecification, this.proxyHeader, this.request, this.response);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setPort(this.port);
            newBuilder.setPortName(this.portName);
            newBuilder.setPortSpecification(this.portSpecification);
            newBuilder.setProxyHeader(this.proxyHeader);
            newBuilder.setRequest(this.request);
            newBuilder.setResponse(this.response);
            return newBuilder;
        }
    }
}

