/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpsProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionTargetHttpsProxyName;
import com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.RegionTargetHttpsProxySettings;
import com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpsProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxyStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionTargetHttpsProxyClient
implements BackgroundResource {
    private final RegionTargetHttpsProxySettings settings;
    private final RegionTargetHttpsProxyStub stub;

    public static final RegionTargetHttpsProxyClient create() throws IOException {
        return RegionTargetHttpsProxyClient.create(RegionTargetHttpsProxySettings.newBuilder().build());
    }

    public static final RegionTargetHttpsProxyClient create(RegionTargetHttpsProxySettings settings) throws IOException {
        return new RegionTargetHttpsProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionTargetHttpsProxyClient create(RegionTargetHttpsProxyStub stub) {
        return new RegionTargetHttpsProxyClient(stub);
    }

    protected RegionTargetHttpsProxyClient(RegionTargetHttpsProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionTargetHttpsProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionTargetHttpsProxyClient(RegionTargetHttpsProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionTargetHttpsProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionTargetHttpsProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpsProxy(ProjectRegionTargetHttpsProxyName targetHttpsProxy) {
        DeleteRegionTargetHttpsProxyHttpRequest request = DeleteRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).build();
        return this.deleteRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpsProxy(String targetHttpsProxy) {
        DeleteRegionTargetHttpsProxyHttpRequest request = DeleteRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).build();
        return this.deleteRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpsProxy(DeleteRegionTargetHttpsProxyHttpRequest request) {
        return (Operation)this.deleteRegionTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionTargetHttpsProxyHttpRequest, Operation> deleteRegionTargetHttpsProxyCallable() {
        return this.stub.deleteRegionTargetHttpsProxyCallable();
    }

    @BetaApi
    public final TargetHttpsProxy getRegionTargetHttpsProxy(ProjectRegionTargetHttpsProxyName targetHttpsProxy) {
        GetRegionTargetHttpsProxyHttpRequest request = GetRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).build();
        return this.getRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final TargetHttpsProxy getRegionTargetHttpsProxy(String targetHttpsProxy) {
        GetRegionTargetHttpsProxyHttpRequest request = GetRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).build();
        return this.getRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final TargetHttpsProxy getRegionTargetHttpsProxy(GetRegionTargetHttpsProxyHttpRequest request) {
        return (TargetHttpsProxy)this.getRegionTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionTargetHttpsProxyHttpRequest, TargetHttpsProxy> getRegionTargetHttpsProxyCallable() {
        return this.stub.getRegionTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation insertRegionTargetHttpsProxy(ProjectRegionName region, TargetHttpsProxy targetHttpsProxyResource) {
        InsertRegionTargetHttpsProxyHttpRequest request = InsertRegionTargetHttpsProxyHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insertRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation insertRegionTargetHttpsProxy(String region, TargetHttpsProxy targetHttpsProxyResource) {
        InsertRegionTargetHttpsProxyHttpRequest request = InsertRegionTargetHttpsProxyHttpRequest.newBuilder().setRegion(region).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insertRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation insertRegionTargetHttpsProxy(InsertRegionTargetHttpsProxyHttpRequest request) {
        return (Operation)this.insertRegionTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionTargetHttpsProxyHttpRequest, Operation> insertRegionTargetHttpsProxyCallable() {
        return this.stub.insertRegionTargetHttpsProxyCallable();
    }

    @BetaApi
    public final ListRegionTargetHttpsProxiesPagedResponse listRegionTargetHttpsProxies(ProjectRegionName region) {
        ListRegionTargetHttpsProxiesHttpRequest request = ListRegionTargetHttpsProxiesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionTargetHttpsProxies(request);
    }

    @BetaApi
    public final ListRegionTargetHttpsProxiesPagedResponse listRegionTargetHttpsProxies(String region) {
        ListRegionTargetHttpsProxiesHttpRequest request = ListRegionTargetHttpsProxiesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionTargetHttpsProxies(request);
    }

    @BetaApi
    public final ListRegionTargetHttpsProxiesPagedResponse listRegionTargetHttpsProxies(ListRegionTargetHttpsProxiesHttpRequest request) {
        return (ListRegionTargetHttpsProxiesPagedResponse)((Object)this.listRegionTargetHttpsProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionTargetHttpsProxiesHttpRequest, ListRegionTargetHttpsProxiesPagedResponse> listRegionTargetHttpsProxiesPagedCallable() {
        return this.stub.listRegionTargetHttpsProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList> listRegionTargetHttpsProxiesCallable() {
        return this.stub.listRegionTargetHttpsProxiesCallable();
    }

    @BetaApi
    public final Operation setSslCertificatesRegionTargetHttpsProxy(ProjectRegionTargetHttpsProxyName targetHttpsProxy, RegionTargetHttpsProxiesSetSslCertificatesRequest regionTargetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesRegionTargetHttpsProxyHttpRequest request = SetSslCertificatesRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setRegionTargetHttpsProxiesSetSslCertificatesRequestResource(regionTargetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesRegionTargetHttpsProxy(String targetHttpsProxy, RegionTargetHttpsProxiesSetSslCertificatesRequest regionTargetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesRegionTargetHttpsProxyHttpRequest request = SetSslCertificatesRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setRegionTargetHttpsProxiesSetSslCertificatesRequestResource(regionTargetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificatesRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setSslCertificatesRegionTargetHttpsProxy(SetSslCertificatesRegionTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setSslCertificatesRegionTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetSslCertificatesRegionTargetHttpsProxyHttpRequest, Operation> setSslCertificatesRegionTargetHttpsProxyCallable() {
        return this.stub.setSslCertificatesRegionTargetHttpsProxyCallable();
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpsProxy(ProjectRegionTargetHttpsProxyName targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpsProxyHttpRequest request = SetUrlMapRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy == null ? null : targetHttpsProxy.toString()).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpsProxy(String targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpsProxyHttpRequest request = SetUrlMapRegionTargetHttpsProxyHttpRequest.newBuilder().setTargetHttpsProxy(targetHttpsProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapRegionTargetHttpsProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpsProxy(SetUrlMapRegionTargetHttpsProxyHttpRequest request) {
        return (Operation)this.setUrlMapRegionTargetHttpsProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetUrlMapRegionTargetHttpsProxyHttpRequest, Operation> setUrlMapRegionTargetHttpsProxyCallable() {
        return this.stub.setUrlMapRegionTargetHttpsProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionTargetHttpsProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListRegionTargetHttpsProxiesPage, ListRegionTargetHttpsProxiesFixedSizeCollection> {
        private ListRegionTargetHttpsProxiesFixedSizeCollection(List<ListRegionTargetHttpsProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionTargetHttpsProxiesFixedSizeCollection createEmptyCollection() {
            return new ListRegionTargetHttpsProxiesFixedSizeCollection(null, 0);
        }

        protected ListRegionTargetHttpsProxiesFixedSizeCollection createCollection(List<ListRegionTargetHttpsProxiesPage> pages, int collectionSize) {
            return new ListRegionTargetHttpsProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionTargetHttpsProxiesPage
    extends AbstractPage<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListRegionTargetHttpsProxiesPage> {
        private ListRegionTargetHttpsProxiesPage(PageContext<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            super(context, (Object)response);
        }

        private static ListRegionTargetHttpsProxiesPage createEmptyPage() {
            return new ListRegionTargetHttpsProxiesPage(null, null);
        }

        protected ListRegionTargetHttpsProxiesPage createPage(PageContext<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            return new ListRegionTargetHttpsProxiesPage(context, response);
        }

        public ApiFuture<ListRegionTargetHttpsProxiesPage> createPageAsync(PageContext<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionTargetHttpsProxiesPagedResponse
    extends AbstractPagedListResponse<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy, ListRegionTargetHttpsProxiesPage, ListRegionTargetHttpsProxiesFixedSizeCollection> {
        public static ApiFuture<ListRegionTargetHttpsProxiesPagedResponse> createAsync(PageContext<ListRegionTargetHttpsProxiesHttpRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            ApiFuture<ListRegionTargetHttpsProxiesPage> futurePage = ListRegionTargetHttpsProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionTargetHttpsProxiesPage, ListRegionTargetHttpsProxiesPagedResponse>(){

                public ListRegionTargetHttpsProxiesPagedResponse apply(ListRegionTargetHttpsProxiesPage input) {
                    return new ListRegionTargetHttpsProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionTargetHttpsProxiesPagedResponse(ListRegionTargetHttpsProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionTargetHttpsProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

