/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpProxiesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectRegionName;
import com.google.cloud.compute.v1.ProjectRegionTargetHttpProxyName;
import com.google.cloud.compute.v1.RegionTargetHttpProxySettings;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpProxyHttpRequest;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.RegionTargetHttpProxyStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpProxyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionTargetHttpProxyClient
implements BackgroundResource {
    private final RegionTargetHttpProxySettings settings;
    private final RegionTargetHttpProxyStub stub;

    public static final RegionTargetHttpProxyClient create() throws IOException {
        return RegionTargetHttpProxyClient.create(RegionTargetHttpProxySettings.newBuilder().build());
    }

    public static final RegionTargetHttpProxyClient create(RegionTargetHttpProxySettings settings) throws IOException {
        return new RegionTargetHttpProxyClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionTargetHttpProxyClient create(RegionTargetHttpProxyStub stub) {
        return new RegionTargetHttpProxyClient(stub);
    }

    protected RegionTargetHttpProxyClient(RegionTargetHttpProxySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionTargetHttpProxyStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionTargetHttpProxyClient(RegionTargetHttpProxyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionTargetHttpProxySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionTargetHttpProxyStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpProxy(ProjectRegionTargetHttpProxyName targetHttpProxy) {
        DeleteRegionTargetHttpProxyHttpRequest request = DeleteRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).build();
        return this.deleteRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpProxy(String targetHttpProxy) {
        DeleteRegionTargetHttpProxyHttpRequest request = DeleteRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).build();
        return this.deleteRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation deleteRegionTargetHttpProxy(DeleteRegionTargetHttpProxyHttpRequest request) {
        return (Operation)this.deleteRegionTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteRegionTargetHttpProxyHttpRequest, Operation> deleteRegionTargetHttpProxyCallable() {
        return this.stub.deleteRegionTargetHttpProxyCallable();
    }

    @BetaApi
    public final TargetHttpProxy getRegionTargetHttpProxy(ProjectRegionTargetHttpProxyName targetHttpProxy) {
        GetRegionTargetHttpProxyHttpRequest request = GetRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).build();
        return this.getRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final TargetHttpProxy getRegionTargetHttpProxy(String targetHttpProxy) {
        GetRegionTargetHttpProxyHttpRequest request = GetRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).build();
        return this.getRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final TargetHttpProxy getRegionTargetHttpProxy(GetRegionTargetHttpProxyHttpRequest request) {
        return (TargetHttpProxy)this.getRegionTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetRegionTargetHttpProxyHttpRequest, TargetHttpProxy> getRegionTargetHttpProxyCallable() {
        return this.stub.getRegionTargetHttpProxyCallable();
    }

    @BetaApi
    public final Operation insertRegionTargetHttpProxy(ProjectRegionName region, TargetHttpProxy targetHttpProxyResource) {
        InsertRegionTargetHttpProxyHttpRequest request = InsertRegionTargetHttpProxyHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation insertRegionTargetHttpProxy(String region, TargetHttpProxy targetHttpProxyResource) {
        InsertRegionTargetHttpProxyHttpRequest request = InsertRegionTargetHttpProxyHttpRequest.newBuilder().setRegion(region).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation insertRegionTargetHttpProxy(InsertRegionTargetHttpProxyHttpRequest request) {
        return (Operation)this.insertRegionTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertRegionTargetHttpProxyHttpRequest, Operation> insertRegionTargetHttpProxyCallable() {
        return this.stub.insertRegionTargetHttpProxyCallable();
    }

    @BetaApi
    public final ListRegionTargetHttpProxiesPagedResponse listRegionTargetHttpProxies(ProjectRegionName region) {
        ListRegionTargetHttpProxiesHttpRequest request = ListRegionTargetHttpProxiesHttpRequest.newBuilder().setRegion(region == null ? null : region.toString()).build();
        return this.listRegionTargetHttpProxies(request);
    }

    @BetaApi
    public final ListRegionTargetHttpProxiesPagedResponse listRegionTargetHttpProxies(String region) {
        ListRegionTargetHttpProxiesHttpRequest request = ListRegionTargetHttpProxiesHttpRequest.newBuilder().setRegion(region).build();
        return this.listRegionTargetHttpProxies(request);
    }

    @BetaApi
    public final ListRegionTargetHttpProxiesPagedResponse listRegionTargetHttpProxies(ListRegionTargetHttpProxiesHttpRequest request) {
        return (ListRegionTargetHttpProxiesPagedResponse)((Object)this.listRegionTargetHttpProxiesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListRegionTargetHttpProxiesHttpRequest, ListRegionTargetHttpProxiesPagedResponse> listRegionTargetHttpProxiesPagedCallable() {
        return this.stub.listRegionTargetHttpProxiesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList> listRegionTargetHttpProxiesCallable() {
        return this.stub.listRegionTargetHttpProxiesCallable();
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpProxy(ProjectRegionTargetHttpProxyName targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpProxyHttpRequest request = SetUrlMapRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy == null ? null : targetHttpProxy.toString()).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpProxy(String targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpProxyHttpRequest request = SetUrlMapRegionTargetHttpProxyHttpRequest.newBuilder().setTargetHttpProxy(targetHttpProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapRegionTargetHttpProxy(request);
    }

    @BetaApi
    public final Operation setUrlMapRegionTargetHttpProxy(SetUrlMapRegionTargetHttpProxyHttpRequest request) {
        return (Operation)this.setUrlMapRegionTargetHttpProxyCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<SetUrlMapRegionTargetHttpProxyHttpRequest, Operation> setUrlMapRegionTargetHttpProxyCallable() {
        return this.stub.setUrlMapRegionTargetHttpProxyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRegionTargetHttpProxiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListRegionTargetHttpProxiesPage, ListRegionTargetHttpProxiesFixedSizeCollection> {
        private ListRegionTargetHttpProxiesFixedSizeCollection(List<ListRegionTargetHttpProxiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRegionTargetHttpProxiesFixedSizeCollection createEmptyCollection() {
            return new ListRegionTargetHttpProxiesFixedSizeCollection(null, 0);
        }

        protected ListRegionTargetHttpProxiesFixedSizeCollection createCollection(List<ListRegionTargetHttpProxiesPage> pages, int collectionSize) {
            return new ListRegionTargetHttpProxiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRegionTargetHttpProxiesPage
    extends AbstractPage<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListRegionTargetHttpProxiesPage> {
        private ListRegionTargetHttpProxiesPage(PageContext<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            super(context, (Object)response);
        }

        private static ListRegionTargetHttpProxiesPage createEmptyPage() {
            return new ListRegionTargetHttpProxiesPage(null, null);
        }

        protected ListRegionTargetHttpProxiesPage createPage(PageContext<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            return new ListRegionTargetHttpProxiesPage(context, response);
        }

        public ApiFuture<ListRegionTargetHttpProxiesPage> createPageAsync(PageContext<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRegionTargetHttpProxiesPagedResponse
    extends AbstractPagedListResponse<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy, ListRegionTargetHttpProxiesPage, ListRegionTargetHttpProxiesFixedSizeCollection> {
        public static ApiFuture<ListRegionTargetHttpProxiesPagedResponse> createAsync(PageContext<ListRegionTargetHttpProxiesHttpRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            ApiFuture<ListRegionTargetHttpProxiesPage> futurePage = ListRegionTargetHttpProxiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRegionTargetHttpProxiesPage, ListRegionTargetHttpProxiesPagedResponse>(){

                public ListRegionTargetHttpProxiesPagedResponse apply(ListRegionTargetHttpProxiesPage input) {
                    return new ListRegionTargetHttpProxiesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRegionTargetHttpProxiesPagedResponse(ListRegionTargetHttpProxiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRegionTargetHttpProxiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

