/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionTargetHttpsProxyName
implements ResourceName {
    private final String project;
    private final String region;
    private final String targetHttpsProxy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/targetHttpsProxies/{targetHttpsProxy}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionTargetHttpsProxyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)builder.getTargetHttpsProxy());
    }

    public static ProjectRegionTargetHttpsProxyName of(String project, String region, String targetHttpsProxy) {
        return ProjectRegionTargetHttpsProxyName.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxy(targetHttpsProxy).build();
    }

    public static String format(String project, String region, String targetHttpsProxy) {
        return ProjectRegionTargetHttpsProxyName.of(project, region, targetHttpsProxy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTargetHttpsProxy() {
        return this.targetHttpsProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionTargetHttpsProxyName projectRegionTargetHttpsProxyName = this;
            synchronized (projectRegionTargetHttpsProxyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"targetHttpsProxy", (Object)this.targetHttpsProxy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionTargetHttpsProxyName> newFactory() {
        return new ResourceNameFactory<ProjectRegionTargetHttpsProxyName>(){

            public ProjectRegionTargetHttpsProxyName parse(String formattedString) {
                return ProjectRegionTargetHttpsProxyName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionTargetHttpsProxyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionTargetHttpsProxyName.parse: formattedString not in valid format");
        return ProjectRegionTargetHttpsProxyName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("targetHttpsProxy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "targetHttpsProxy", this.targetHttpsProxy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionTargetHttpsProxyName) {
            ProjectRegionTargetHttpsProxyName that = (ProjectRegionTargetHttpsProxyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.targetHttpsProxy, that.getTargetHttpsProxy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.targetHttpsProxy);
    }

    public static class Builder {
        private String project;
        private String region;
        private String targetHttpsProxy;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getTargetHttpsProxy() {
            return this.targetHttpsProxy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setTargetHttpsProxy(String targetHttpsProxy) {
            this.targetHttpsProxy = targetHttpsProxy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionTargetHttpsProxyName projectRegionTargetHttpsProxyName) {
            this.project = projectRegionTargetHttpsProxyName.project;
            this.region = projectRegionTargetHttpsProxyName.region;
            this.targetHttpsProxy = projectRegionTargetHttpsProxyName.targetHttpsProxy;
        }

        public ProjectRegionTargetHttpsProxyName build() {
            return new ProjectRegionTargetHttpsProxyName(this);
        }
    }
}

