/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.WafExpressionSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PreconfiguredWafSet
implements ApiMessage {
    private final List<WafExpressionSet> expressionSets;
    private static final PreconfiguredWafSet DEFAULT_INSTANCE = new PreconfiguredWafSet();

    private PreconfiguredWafSet() {
        this.expressionSets = null;
    }

    private PreconfiguredWafSet(List<WafExpressionSet> expressionSets) {
        this.expressionSets = expressionSets;
    }

    public Object getFieldValue(String fieldName) {
        if ("expressionSets".equals(fieldName)) {
            return this.expressionSets;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<WafExpressionSet> getExpressionSetsList() {
        return this.expressionSets;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PreconfiguredWafSet prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PreconfiguredWafSet getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PreconfiguredWafSet{expressionSets=" + this.expressionSets + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PreconfiguredWafSet) {
            PreconfiguredWafSet that = (PreconfiguredWafSet)o;
            return Objects.equals(this.expressionSets, that.getExpressionSetsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.expressionSets);
    }

    public static class Builder {
        private List<WafExpressionSet> expressionSets;

        Builder() {
        }

        public Builder mergeFrom(PreconfiguredWafSet other) {
            if (other == PreconfiguredWafSet.getDefaultInstance()) {
                return this;
            }
            if (other.getExpressionSetsList() != null) {
                this.expressionSets = other.expressionSets;
            }
            return this;
        }

        Builder(PreconfiguredWafSet source) {
            this.expressionSets = source.expressionSets;
        }

        public List<WafExpressionSet> getExpressionSetsList() {
            return this.expressionSets;
        }

        public Builder addAllExpressionSets(List<WafExpressionSet> expressionSets) {
            if (this.expressionSets == null) {
                this.expressionSets = new LinkedList<WafExpressionSet>();
            }
            this.expressionSets.addAll(expressionSets);
            return this;
        }

        public Builder addExpressionSets(WafExpressionSet expressionSets) {
            if (this.expressionSets == null) {
                this.expressionSets = new LinkedList<WafExpressionSet>();
            }
            this.expressionSets.add(expressionSets);
            return this;
        }

        public PreconfiguredWafSet build() {
            return new PreconfiguredWafSet(this.expressionSets);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllExpressionSets(this.expressionSets);
            return newBuilder;
        }
    }
}

