/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.FileContentBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InitialStateConfig
implements ApiMessage {
    private final List<FileContentBuffer> dbs;
    private final List<FileContentBuffer> dbxs;
    private final List<FileContentBuffer> keks;
    private final FileContentBuffer pk;
    private static final InitialStateConfig DEFAULT_INSTANCE = new InitialStateConfig();

    private InitialStateConfig() {
        this.dbs = null;
        this.dbxs = null;
        this.keks = null;
        this.pk = null;
    }

    private InitialStateConfig(List<FileContentBuffer> dbs, List<FileContentBuffer> dbxs, List<FileContentBuffer> keks, FileContentBuffer pk) {
        this.dbs = dbs;
        this.dbxs = dbxs;
        this.keks = keks;
        this.pk = pk;
    }

    public Object getFieldValue(String fieldName) {
        if ("dbs".equals(fieldName)) {
            return this.dbs;
        }
        if ("dbxs".equals(fieldName)) {
            return this.dbxs;
        }
        if ("keks".equals(fieldName)) {
            return this.keks;
        }
        if ("pk".equals(fieldName)) {
            return this.pk;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<FileContentBuffer> getDbsList() {
        return this.dbs;
    }

    public List<FileContentBuffer> getDbxsList() {
        return this.dbxs;
    }

    public List<FileContentBuffer> getKeksList() {
        return this.keks;
    }

    public FileContentBuffer getPk() {
        return this.pk;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InitialStateConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InitialStateConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InitialStateConfig{dbs=" + this.dbs + ", dbxs=" + this.dbxs + ", keks=" + this.keks + ", pk=" + this.pk + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InitialStateConfig) {
            InitialStateConfig that = (InitialStateConfig)o;
            return Objects.equals(this.dbs, that.getDbsList()) && Objects.equals(this.dbxs, that.getDbxsList()) && Objects.equals(this.keks, that.getKeksList()) && Objects.equals(this.pk, that.getPk());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dbs, this.dbxs, this.keks, this.pk);
    }

    public static class Builder {
        private List<FileContentBuffer> dbs;
        private List<FileContentBuffer> dbxs;
        private List<FileContentBuffer> keks;
        private FileContentBuffer pk;

        Builder() {
        }

        public Builder mergeFrom(InitialStateConfig other) {
            if (other == InitialStateConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getDbsList() != null) {
                this.dbs = other.dbs;
            }
            if (other.getDbxsList() != null) {
                this.dbxs = other.dbxs;
            }
            if (other.getKeksList() != null) {
                this.keks = other.keks;
            }
            if (other.getPk() != null) {
                this.pk = other.pk;
            }
            return this;
        }

        Builder(InitialStateConfig source) {
            this.dbs = source.dbs;
            this.dbxs = source.dbxs;
            this.keks = source.keks;
            this.pk = source.pk;
        }

        public List<FileContentBuffer> getDbsList() {
            return this.dbs;
        }

        public Builder addAllDbs(List<FileContentBuffer> dbs) {
            if (this.dbs == null) {
                this.dbs = new LinkedList<FileContentBuffer>();
            }
            this.dbs.addAll(dbs);
            return this;
        }

        public Builder addDbs(FileContentBuffer dbs) {
            if (this.dbs == null) {
                this.dbs = new LinkedList<FileContentBuffer>();
            }
            this.dbs.add(dbs);
            return this;
        }

        public List<FileContentBuffer> getDbxsList() {
            return this.dbxs;
        }

        public Builder addAllDbxs(List<FileContentBuffer> dbxs) {
            if (this.dbxs == null) {
                this.dbxs = new LinkedList<FileContentBuffer>();
            }
            this.dbxs.addAll(dbxs);
            return this;
        }

        public Builder addDbxs(FileContentBuffer dbxs) {
            if (this.dbxs == null) {
                this.dbxs = new LinkedList<FileContentBuffer>();
            }
            this.dbxs.add(dbxs);
            return this;
        }

        public List<FileContentBuffer> getKeksList() {
            return this.keks;
        }

        public Builder addAllKeks(List<FileContentBuffer> keks) {
            if (this.keks == null) {
                this.keks = new LinkedList<FileContentBuffer>();
            }
            this.keks.addAll(keks);
            return this;
        }

        public Builder addKeks(FileContentBuffer keks) {
            if (this.keks == null) {
                this.keks = new LinkedList<FileContentBuffer>();
            }
            this.keks.add(keks);
            return this;
        }

        public FileContentBuffer getPk() {
            return this.pk;
        }

        public Builder setPk(FileContentBuffer pk) {
            this.pk = pk;
            return this;
        }

        public InitialStateConfig build() {
            return new InitialStateConfig(this.dbs, this.dbxs, this.keks, this.pk);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllDbs(this.dbs);
            newBuilder.addAllDbxs(this.dbxs);
            newBuilder.addAllKeks(this.keks);
            newBuilder.setPk(this.pk);
            return newBuilder;
        }
    }
}

