/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HealthStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class BackendServiceGroupHealth
implements ApiMessage {
    private final Map<String, String> annotations;
    private final List<HealthStatus> healthStatus;
    private final String kind;
    private static final BackendServiceGroupHealth DEFAULT_INSTANCE = new BackendServiceGroupHealth();

    private BackendServiceGroupHealth() {
        this.annotations = null;
        this.healthStatus = null;
        this.kind = null;
    }

    private BackendServiceGroupHealth(Map<String, String> annotations, List<HealthStatus> healthStatus, String kind) {
        this.annotations = annotations;
        this.healthStatus = healthStatus;
        this.kind = kind;
    }

    public Object getFieldValue(String fieldName) {
        if ("annotations".equals(fieldName)) {
            return this.annotations;
        }
        if ("healthStatus".equals(fieldName)) {
            return this.healthStatus;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Map<String, String> getAnnotationsMap() {
        return this.annotations;
    }

    public List<HealthStatus> getHealthStatusList() {
        return this.healthStatus;
    }

    public String getKind() {
        return this.kind;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(BackendServiceGroupHealth prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static BackendServiceGroupHealth getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "BackendServiceGroupHealth{annotations=" + this.annotations + ", healthStatus=" + this.healthStatus + ", kind=" + this.kind + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendServiceGroupHealth) {
            BackendServiceGroupHealth that = (BackendServiceGroupHealth)o;
            return Objects.equals(this.annotations, that.getAnnotationsMap()) && Objects.equals(this.healthStatus, that.getHealthStatusList()) && Objects.equals(this.kind, that.getKind());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.healthStatus, this.kind);
    }

    public static class Builder {
        private Map<String, String> annotations;
        private List<HealthStatus> healthStatus;
        private String kind;

        Builder() {
        }

        public Builder mergeFrom(BackendServiceGroupHealth other) {
            if (other == BackendServiceGroupHealth.getDefaultInstance()) {
                return this;
            }
            if (other.getAnnotationsMap() != null) {
                this.annotations = other.annotations;
            }
            if (other.getHealthStatusList() != null) {
                this.healthStatus = other.healthStatus;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            return this;
        }

        Builder(BackendServiceGroupHealth source) {
            this.annotations = source.annotations;
            this.healthStatus = source.healthStatus;
            this.kind = source.kind;
        }

        public Map<String, String> getAnnotationsMap() {
            return this.annotations;
        }

        public Builder putAllAnnotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public List<HealthStatus> getHealthStatusList() {
            return this.healthStatus;
        }

        public Builder addAllHealthStatus(List<HealthStatus> healthStatus) {
            if (this.healthStatus == null) {
                this.healthStatus = new LinkedList<HealthStatus>();
            }
            this.healthStatus.addAll(healthStatus);
            return this;
        }

        public Builder addHealthStatus(HealthStatus healthStatus) {
            if (this.healthStatus == null) {
                this.healthStatus = new LinkedList<HealthStatus>();
            }
            this.healthStatus.add(healthStatus);
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public BackendServiceGroupHealth build() {
            return new BackendServiceGroupHealth(this.annotations, this.healthStatus, this.kind);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.putAllAnnotations(this.annotations);
            newBuilder.addAllHealthStatus(this.healthStatus);
            newBuilder.setKind(this.kind);
            return newBuilder;
        }
    }
}

