/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.gson.annotations.SerializedName;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PacketMirroringFilter
implements ApiMessage {
    private final List<String> cidrRanges;
    @SerializedName(value="IPProtocols")
    private final List<String> iPProtocols;
    private static final PacketMirroringFilter DEFAULT_INSTANCE = new PacketMirroringFilter();

    private PacketMirroringFilter() {
        this.cidrRanges = null;
        this.iPProtocols = null;
    }

    private PacketMirroringFilter(List<String> cidrRanges, List<String> iPProtocols) {
        this.cidrRanges = cidrRanges;
        this.iPProtocols = iPProtocols;
    }

    public Object getFieldValue(String fieldName) {
        if ("cidrRanges".equals(fieldName)) {
            return this.cidrRanges;
        }
        if ("iPProtocols".equals(fieldName)) {
            return this.iPProtocols;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getCidrRangesList() {
        return this.cidrRanges;
    }

    public List<String> getIPProtocolsList() {
        return this.iPProtocols;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PacketMirroringFilter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PacketMirroringFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PacketMirroringFilter{cidrRanges=" + this.cidrRanges + ", iPProtocols=" + this.iPProtocols + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PacketMirroringFilter) {
            PacketMirroringFilter that = (PacketMirroringFilter)o;
            return Objects.equals(this.cidrRanges, that.getCidrRangesList()) && Objects.equals(this.iPProtocols, that.getIPProtocolsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.cidrRanges, this.iPProtocols);
    }

    public static class Builder {
        private List<String> cidrRanges;
        private List<String> iPProtocols;

        Builder() {
        }

        public Builder mergeFrom(PacketMirroringFilter other) {
            if (other == PacketMirroringFilter.getDefaultInstance()) {
                return this;
            }
            if (other.getCidrRangesList() != null) {
                this.cidrRanges = other.cidrRanges;
            }
            if (other.getIPProtocolsList() != null) {
                this.iPProtocols = other.iPProtocols;
            }
            return this;
        }

        Builder(PacketMirroringFilter source) {
            this.cidrRanges = source.cidrRanges;
            this.iPProtocols = source.iPProtocols;
        }

        public List<String> getCidrRangesList() {
            return this.cidrRanges;
        }

        public Builder addAllCidrRanges(List<String> cidrRanges) {
            if (this.cidrRanges == null) {
                this.cidrRanges = new LinkedList<String>();
            }
            this.cidrRanges.addAll(cidrRanges);
            return this;
        }

        public Builder addCidrRanges(String cidrRanges) {
            if (this.cidrRanges == null) {
                this.cidrRanges = new LinkedList<String>();
            }
            this.cidrRanges.add(cidrRanges);
            return this;
        }

        public List<String> getIPProtocolsList() {
            return this.iPProtocols;
        }

        public Builder addAllIPProtocols(List<String> iPProtocols) {
            if (this.iPProtocols == null) {
                this.iPProtocols = new LinkedList<String>();
            }
            this.iPProtocols.addAll(iPProtocols);
            return this;
        }

        public Builder addIPProtocols(String iPProtocols) {
            if (this.iPProtocols == null) {
                this.iPProtocols = new LinkedList<String>();
            }
            this.iPProtocols.add(iPProtocols);
            return this;
        }

        public PacketMirroringFilter build() {
            return new PacketMirroringFilter(this.cidrRanges, this.iPProtocols);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllCidrRanges(this.cidrRanges);
            newBuilder.addAllIPProtocols(this.iPProtocols);
            return newBuilder;
        }
    }
}

