/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.InstanceGroupManagerStatusStatefulPerInstanceConfigs;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class InstanceGroupManagerStatusStateful
implements ApiMessage {
    private final Boolean hasStatefulConfig;
    private final InstanceGroupManagerStatusStatefulPerInstanceConfigs perInstanceConfigs;
    private static final InstanceGroupManagerStatusStateful DEFAULT_INSTANCE = new InstanceGroupManagerStatusStateful();

    private InstanceGroupManagerStatusStateful() {
        this.hasStatefulConfig = null;
        this.perInstanceConfigs = null;
    }

    private InstanceGroupManagerStatusStateful(Boolean hasStatefulConfig, InstanceGroupManagerStatusStatefulPerInstanceConfigs perInstanceConfigs) {
        this.hasStatefulConfig = hasStatefulConfig;
        this.perInstanceConfigs = perInstanceConfigs;
    }

    public Object getFieldValue(String fieldName) {
        if ("hasStatefulConfig".equals(fieldName)) {
            return this.hasStatefulConfig;
        }
        if ("perInstanceConfigs".equals(fieldName)) {
            return this.perInstanceConfigs;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getHasStatefulConfig() {
        return this.hasStatefulConfig;
    }

    public InstanceGroupManagerStatusStatefulPerInstanceConfigs getPerInstanceConfigs() {
        return this.perInstanceConfigs;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(InstanceGroupManagerStatusStateful prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static InstanceGroupManagerStatusStateful getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "InstanceGroupManagerStatusStateful{hasStatefulConfig=" + this.hasStatefulConfig + ", perInstanceConfigs=" + this.perInstanceConfigs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceGroupManagerStatusStateful) {
            InstanceGroupManagerStatusStateful that = (InstanceGroupManagerStatusStateful)o;
            return Objects.equals(this.hasStatefulConfig, that.getHasStatefulConfig()) && Objects.equals(this.perInstanceConfigs, that.getPerInstanceConfigs());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.hasStatefulConfig, this.perInstanceConfigs);
    }

    public static class Builder {
        private Boolean hasStatefulConfig;
        private InstanceGroupManagerStatusStatefulPerInstanceConfigs perInstanceConfigs;

        Builder() {
        }

        public Builder mergeFrom(InstanceGroupManagerStatusStateful other) {
            if (other == InstanceGroupManagerStatusStateful.getDefaultInstance()) {
                return this;
            }
            if (other.getHasStatefulConfig() != null) {
                this.hasStatefulConfig = other.hasStatefulConfig;
            }
            if (other.getPerInstanceConfigs() != null) {
                this.perInstanceConfigs = other.perInstanceConfigs;
            }
            return this;
        }

        Builder(InstanceGroupManagerStatusStateful source) {
            this.hasStatefulConfig = source.hasStatefulConfig;
            this.perInstanceConfigs = source.perInstanceConfigs;
        }

        public Boolean getHasStatefulConfig() {
            return this.hasStatefulConfig;
        }

        public Builder setHasStatefulConfig(Boolean hasStatefulConfig) {
            this.hasStatefulConfig = hasStatefulConfig;
            return this;
        }

        public InstanceGroupManagerStatusStatefulPerInstanceConfigs getPerInstanceConfigs() {
            return this.perInstanceConfigs;
        }

        public Builder setPerInstanceConfigs(InstanceGroupManagerStatusStatefulPerInstanceConfigs perInstanceConfigs) {
            this.perInstanceConfigs = perInstanceConfigs;
            return this;
        }

        public InstanceGroupManagerStatusStateful build() {
            return new InstanceGroupManagerStatusStateful(this.hasStatefulConfig, this.perInstanceConfigs);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setHasStatefulConfig(this.hasStatefulConfig);
            newBuilder.setPerInstanceConfigs(this.perInstanceConfigs);
            return newBuilder;
        }
    }
}

