/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.FixedOrPercent;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class AutoscalingPolicyScaleInControl
implements ApiMessage {
    private final FixedOrPercent maxScaledInReplicas;
    private final Integer timeWindowSec;
    private static final AutoscalingPolicyScaleInControl DEFAULT_INSTANCE = new AutoscalingPolicyScaleInControl();

    private AutoscalingPolicyScaleInControl() {
        this.maxScaledInReplicas = null;
        this.timeWindowSec = null;
    }

    private AutoscalingPolicyScaleInControl(FixedOrPercent maxScaledInReplicas, Integer timeWindowSec) {
        this.maxScaledInReplicas = maxScaledInReplicas;
        this.timeWindowSec = timeWindowSec;
    }

    public Object getFieldValue(String fieldName) {
        if ("maxScaledInReplicas".equals(fieldName)) {
            return this.maxScaledInReplicas;
        }
        if ("timeWindowSec".equals(fieldName)) {
            return this.timeWindowSec;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public FixedOrPercent getMaxScaledInReplicas() {
        return this.maxScaledInReplicas;
    }

    public Integer getTimeWindowSec() {
        return this.timeWindowSec;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AutoscalingPolicyScaleInControl prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static AutoscalingPolicyScaleInControl getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "AutoscalingPolicyScaleInControl{maxScaledInReplicas=" + this.maxScaledInReplicas + ", timeWindowSec=" + this.timeWindowSec + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AutoscalingPolicyScaleInControl) {
            AutoscalingPolicyScaleInControl that = (AutoscalingPolicyScaleInControl)o;
            return Objects.equals(this.maxScaledInReplicas, that.getMaxScaledInReplicas()) && Objects.equals(this.timeWindowSec, that.getTimeWindowSec());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.maxScaledInReplicas, this.timeWindowSec);
    }

    public static class Builder {
        private FixedOrPercent maxScaledInReplicas;
        private Integer timeWindowSec;

        Builder() {
        }

        public Builder mergeFrom(AutoscalingPolicyScaleInControl other) {
            if (other == AutoscalingPolicyScaleInControl.getDefaultInstance()) {
                return this;
            }
            if (other.getMaxScaledInReplicas() != null) {
                this.maxScaledInReplicas = other.maxScaledInReplicas;
            }
            if (other.getTimeWindowSec() != null) {
                this.timeWindowSec = other.timeWindowSec;
            }
            return this;
        }

        Builder(AutoscalingPolicyScaleInControl source) {
            this.maxScaledInReplicas = source.maxScaledInReplicas;
            this.timeWindowSec = source.timeWindowSec;
        }

        public FixedOrPercent getMaxScaledInReplicas() {
            return this.maxScaledInReplicas;
        }

        public Builder setMaxScaledInReplicas(FixedOrPercent maxScaledInReplicas) {
            this.maxScaledInReplicas = maxScaledInReplicas;
            return this;
        }

        public Integer getTimeWindowSec() {
            return this.timeWindowSec;
        }

        public Builder setTimeWindowSec(Integer timeWindowSec) {
            this.timeWindowSec = timeWindowSec;
            return this;
        }

        public AutoscalingPolicyScaleInControl build() {
            return new AutoscalingPolicyScaleInControl(this.maxScaledInReplicas, this.timeWindowSec);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setMaxScaledInReplicas(this.maxScaledInReplicas);
            newBuilder.setTimeWindowSec(this.timeWindowSec);
            return newBuilder;
        }
    }
}

