/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.ResourcePolicyGroupPlacementPolicy;
import com.google.cloud.compute.v1.ResourcePolicySnapshotSchedulePolicy;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ResourcePolicy
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final ResourcePolicyGroupPlacementPolicy groupPlacementPolicy;
    private final String id;
    private final String kind;
    private final String name;
    private final String region;
    private final String selfLink;
    private final ResourcePolicySnapshotSchedulePolicy snapshotSchedulePolicy;
    private final String status;
    private static final ResourcePolicy DEFAULT_INSTANCE = new ResourcePolicy();

    private ResourcePolicy() {
        this.creationTimestamp = null;
        this.description = null;
        this.groupPlacementPolicy = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.region = null;
        this.selfLink = null;
        this.snapshotSchedulePolicy = null;
        this.status = null;
    }

    private ResourcePolicy(String creationTimestamp, String description, ResourcePolicyGroupPlacementPolicy groupPlacementPolicy, String id, String kind, String name, String region, String selfLink, ResourcePolicySnapshotSchedulePolicy snapshotSchedulePolicy, String status) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.groupPlacementPolicy = groupPlacementPolicy;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.region = region;
        this.selfLink = selfLink;
        this.snapshotSchedulePolicy = snapshotSchedulePolicy;
        this.status = status;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("groupPlacementPolicy".equals(fieldName)) {
            return this.groupPlacementPolicy;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("snapshotSchedulePolicy".equals(fieldName)) {
            return this.snapshotSchedulePolicy;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public ResourcePolicyGroupPlacementPolicy getGroupPlacementPolicy() {
        return this.groupPlacementPolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public ResourcePolicySnapshotSchedulePolicy getSnapshotSchedulePolicy() {
        return this.snapshotSchedulePolicy;
    }

    public String getStatus() {
        return this.status;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ResourcePolicy prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ResourcePolicy getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ResourcePolicy{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", groupPlacementPolicy=" + this.groupPlacementPolicy + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", region=" + this.region + ", selfLink=" + this.selfLink + ", snapshotSchedulePolicy=" + this.snapshotSchedulePolicy + ", status=" + this.status + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ResourcePolicy) {
            ResourcePolicy that = (ResourcePolicy)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.groupPlacementPolicy, that.getGroupPlacementPolicy()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.snapshotSchedulePolicy, that.getSnapshotSchedulePolicy()) && Objects.equals(this.status, that.getStatus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.groupPlacementPolicy, this.id, this.kind, this.name, this.region, this.selfLink, this.snapshotSchedulePolicy, this.status);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private ResourcePolicyGroupPlacementPolicy groupPlacementPolicy;
        private String id;
        private String kind;
        private String name;
        private String region;
        private String selfLink;
        private ResourcePolicySnapshotSchedulePolicy snapshotSchedulePolicy;
        private String status;

        Builder() {
        }

        public Builder mergeFrom(ResourcePolicy other) {
            if (other == ResourcePolicy.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getGroupPlacementPolicy() != null) {
                this.groupPlacementPolicy = other.groupPlacementPolicy;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getSnapshotSchedulePolicy() != null) {
                this.snapshotSchedulePolicy = other.snapshotSchedulePolicy;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            return this;
        }

        Builder(ResourcePolicy source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.groupPlacementPolicy = source.groupPlacementPolicy;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.snapshotSchedulePolicy = source.snapshotSchedulePolicy;
            this.status = source.status;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ResourcePolicyGroupPlacementPolicy getGroupPlacementPolicy() {
            return this.groupPlacementPolicy;
        }

        public Builder setGroupPlacementPolicy(ResourcePolicyGroupPlacementPolicy groupPlacementPolicy) {
            this.groupPlacementPolicy = groupPlacementPolicy;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public ResourcePolicySnapshotSchedulePolicy getSnapshotSchedulePolicy() {
            return this.snapshotSchedulePolicy;
        }

        public Builder setSnapshotSchedulePolicy(ResourcePolicySnapshotSchedulePolicy snapshotSchedulePolicy) {
            this.snapshotSchedulePolicy = snapshotSchedulePolicy;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public ResourcePolicy build() {
            return new ResourcePolicy(this.creationTimestamp, this.description, this.groupPlacementPolicy, this.id, this.kind, this.name, this.region, this.selfLink, this.snapshotSchedulePolicy, this.status);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.setGroupPlacementPolicy(this.groupPlacementPolicy);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setSnapshotSchedulePolicy(this.snapshotSchedulePolicy);
            newBuilder.setStatus(this.status);
            return newBuilder;
        }
    }
}

