/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.Duration;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class HttpFaultDelay
implements ApiMessage {
    private final Duration fixedDelay;
    private final Double percentage;
    private static final HttpFaultDelay DEFAULT_INSTANCE = new HttpFaultDelay();

    private HttpFaultDelay() {
        this.fixedDelay = null;
        this.percentage = null;
    }

    private HttpFaultDelay(Duration fixedDelay, Double percentage) {
        this.fixedDelay = fixedDelay;
        this.percentage = percentage;
    }

    public Object getFieldValue(String fieldName) {
        if ("fixedDelay".equals(fieldName)) {
            return this.fixedDelay;
        }
        if ("percentage".equals(fieldName)) {
            return this.percentage;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Duration getFixedDelay() {
        return this.fixedDelay;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HttpFaultDelay prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static HttpFaultDelay getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "HttpFaultDelay{fixedDelay=" + this.fixedDelay + ", percentage=" + this.percentage + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpFaultDelay) {
            HttpFaultDelay that = (HttpFaultDelay)o;
            return Objects.equals(this.fixedDelay, that.getFixedDelay()) && Objects.equals(this.percentage, that.getPercentage());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fixedDelay, this.percentage);
    }

    public static class Builder {
        private Duration fixedDelay;
        private Double percentage;

        Builder() {
        }

        public Builder mergeFrom(HttpFaultDelay other) {
            if (other == HttpFaultDelay.getDefaultInstance()) {
                return this;
            }
            if (other.getFixedDelay() != null) {
                this.fixedDelay = other.fixedDelay;
            }
            if (other.getPercentage() != null) {
                this.percentage = other.percentage;
            }
            return this;
        }

        Builder(HttpFaultDelay source) {
            this.fixedDelay = source.fixedDelay;
            this.percentage = source.percentage;
        }

        public Duration getFixedDelay() {
            return this.fixedDelay;
        }

        public Builder setFixedDelay(Duration fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        public Double getPercentage() {
            return this.percentage;
        }

        public Builder setPercentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        public HttpFaultDelay build() {
            return new HttpFaultDelay(this.fixedDelay, this.percentage);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setFixedDelay(this.fixedDelay);
            newBuilder.setPercentage(this.percentage);
            return newBuilder;
        }
    }
}

