/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteZoneOperationHttpRequest;
import com.google.cloud.compute.v1.GetZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ListZoneOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.WaitZoneOperationHttpRequest;
import com.google.cloud.compute.v1.ZoneOperationClient;
import com.google.cloud.compute.v1.stub.HttpJsonZoneOperationStub;
import com.google.cloud.compute.v1.stub.ZoneOperationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ZoneOperationStubSettings
extends StubSettings<ZoneOperationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationSettings;
    private final UnaryCallSettings<GetZoneOperationHttpRequest, Operation> getZoneOperationSettings;
    private final PagedCallSettings<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsSettings;
    private final UnaryCallSettings<WaitZoneOperationHttpRequest, Operation> waitZoneOperationSettings;
    private static final PagedListDescriptor<ListZoneOperationsHttpRequest, OperationList, Operation> LIST_ZONE_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListZoneOperationsHttpRequest, OperationList, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListZoneOperationsHttpRequest injectToken(ListZoneOperationsHttpRequest payload, String token) {
            return ListZoneOperationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListZoneOperationsHttpRequest injectPageSize(ListZoneOperationsHttpRequest payload, int pageSize) {
            return ListZoneOperationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListZoneOperationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(OperationList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse> LIST_ZONE_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse>(){

        public ApiFuture<ZoneOperationClient.ListZoneOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListZoneOperationsHttpRequest, OperationList> callable, ListZoneOperationsHttpRequest request, ApiCallContext context, ApiFuture<OperationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ZONE_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ZoneOperationClient.ListZoneOperationsPagedResponse.createAsync((PageContext<ListZoneOperationsHttpRequest, OperationList, Operation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationSettings() {
        return this.deleteZoneOperationSettings;
    }

    public UnaryCallSettings<GetZoneOperationHttpRequest, Operation> getZoneOperationSettings() {
        return this.getZoneOperationSettings;
    }

    public PagedCallSettings<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsSettings() {
        return this.listZoneOperationsSettings;
    }

    public UnaryCallSettings<WaitZoneOperationHttpRequest, Operation> waitZoneOperationSettings() {
        return this.waitZoneOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZoneOperationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonZoneOperationStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ZoneOperationStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ZoneOperationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ZoneOperationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteZoneOperationSettings = settingsBuilder.deleteZoneOperationSettings().build();
        this.getZoneOperationSettings = settingsBuilder.getZoneOperationSettings().build();
        this.listZoneOperationsSettings = settingsBuilder.listZoneOperationsSettings().build();
        this.waitZoneOperationSettings = settingsBuilder.waitZoneOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ZoneOperationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationSettings;
        private final UnaryCallSettings.Builder<GetZoneOperationHttpRequest, Operation> getZoneOperationSettings;
        private final PagedCallSettings.Builder<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsSettings;
        private final UnaryCallSettings.Builder<WaitZoneOperationHttpRequest, Operation> waitZoneOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteZoneOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getZoneOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listZoneOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ZONE_OPERATIONS_PAGE_STR_FACT);
            this.waitZoneOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteZoneOperationSettings, this.getZoneOperationSettings, this.listZoneOperationsSettings, this.waitZoneOperationSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ZoneOperationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ZoneOperationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ZoneOperationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ZoneOperationStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteZoneOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getZoneOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listZoneOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.waitZoneOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ZoneOperationStubSettings settings) {
            super((StubSettings)settings);
            this.deleteZoneOperationSettings = settings.deleteZoneOperationSettings.toBuilder();
            this.getZoneOperationSettings = settings.getZoneOperationSettings.toBuilder();
            this.listZoneOperationsSettings = settings.listZoneOperationsSettings.toBuilder();
            this.waitZoneOperationSettings = settings.waitZoneOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteZoneOperationSettings, this.getZoneOperationSettings, this.listZoneOperationsSettings, this.waitZoneOperationSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteZoneOperationHttpRequest, Void> deleteZoneOperationSettings() {
            return this.deleteZoneOperationSettings;
        }

        public UnaryCallSettings.Builder<GetZoneOperationHttpRequest, Operation> getZoneOperationSettings() {
            return this.getZoneOperationSettings;
        }

        public PagedCallSettings.Builder<ListZoneOperationsHttpRequest, OperationList, ZoneOperationClient.ListZoneOperationsPagedResponse> listZoneOperationsSettings() {
            return this.listZoneOperationsSettings;
        }

        public UnaryCallSettings.Builder<WaitZoneOperationHttpRequest, Operation> waitZoneOperationSettings() {
            return this.waitZoneOperationSettings;
        }

        public ZoneOperationStubSettings build() throws IOException {
            return new ZoneOperationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

