/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class FirewallLogConfig
implements ApiMessage {
    private final Boolean enable;
    private final String metadata;
    private static final FirewallLogConfig DEFAULT_INSTANCE = new FirewallLogConfig();

    private FirewallLogConfig() {
        this.enable = null;
        this.metadata = null;
    }

    private FirewallLogConfig(Boolean enable, String metadata) {
        this.enable = enable;
        this.metadata = metadata;
    }

    public Object getFieldValue(String fieldName) {
        if ("enable".equals(fieldName)) {
            return this.enable;
        }
        if ("metadata".equals(fieldName)) {
            return this.metadata;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(FirewallLogConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static FirewallLogConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "FirewallLogConfig{enable=" + this.enable + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FirewallLogConfig) {
            FirewallLogConfig that = (FirewallLogConfig)o;
            return Objects.equals(this.enable, that.getEnable()) && Objects.equals(this.metadata, that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.enable, this.metadata);
    }

    public static class Builder {
        private Boolean enable;
        private String metadata;

        Builder() {
        }

        public Builder mergeFrom(FirewallLogConfig other) {
            if (other == FirewallLogConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getEnable() != null) {
                this.enable = other.enable;
            }
            if (other.getMetadata() != null) {
                this.metadata = other.metadata;
            }
            return this;
        }

        Builder(FirewallLogConfig source) {
            this.enable = source.enable;
            this.metadata = source.metadata;
        }

        public Boolean getEnable() {
            return this.enable;
        }

        public Builder setEnable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public FirewallLogConfig build() {
            return new FirewallLogConfig(this.enable, this.metadata);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setEnable(this.enable);
            newBuilder.setMetadata(this.metadata);
            return newBuilder;
        }
    }
}

