/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class SubnetworkLogConfig
implements ApiMessage {
    private final String aggregationInterval;
    private final Boolean enable;
    private final Float flowSampling;
    private final String metadata;
    private static final SubnetworkLogConfig DEFAULT_INSTANCE = new SubnetworkLogConfig();

    private SubnetworkLogConfig() {
        this.aggregationInterval = null;
        this.enable = null;
        this.flowSampling = null;
        this.metadata = null;
    }

    private SubnetworkLogConfig(String aggregationInterval, Boolean enable, Float flowSampling, String metadata) {
        this.aggregationInterval = aggregationInterval;
        this.enable = enable;
        this.flowSampling = flowSampling;
        this.metadata = metadata;
    }

    public Object getFieldValue(String fieldName) {
        if ("aggregationInterval".equals(fieldName)) {
            return this.aggregationInterval;
        }
        if ("enable".equals(fieldName)) {
            return this.enable;
        }
        if ("flowSampling".equals(fieldName)) {
            return this.flowSampling;
        }
        if ("metadata".equals(fieldName)) {
            return this.metadata;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getAggregationInterval() {
        return this.aggregationInterval;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Float getFlowSampling() {
        return this.flowSampling;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(SubnetworkLogConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static SubnetworkLogConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "SubnetworkLogConfig{aggregationInterval=" + this.aggregationInterval + ", enable=" + this.enable + ", flowSampling=" + this.flowSampling + ", metadata=" + this.metadata + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubnetworkLogConfig) {
            SubnetworkLogConfig that = (SubnetworkLogConfig)o;
            return Objects.equals(this.aggregationInterval, that.getAggregationInterval()) && Objects.equals(this.enable, that.getEnable()) && Objects.equals(this.flowSampling, that.getFlowSampling()) && Objects.equals(this.metadata, that.getMetadata());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.aggregationInterval, this.enable, this.flowSampling, this.metadata);
    }

    public static class Builder {
        private String aggregationInterval;
        private Boolean enable;
        private Float flowSampling;
        private String metadata;

        Builder() {
        }

        public Builder mergeFrom(SubnetworkLogConfig other) {
            if (other == SubnetworkLogConfig.getDefaultInstance()) {
                return this;
            }
            if (other.getAggregationInterval() != null) {
                this.aggregationInterval = other.aggregationInterval;
            }
            if (other.getEnable() != null) {
                this.enable = other.enable;
            }
            if (other.getFlowSampling() != null) {
                this.flowSampling = other.flowSampling;
            }
            if (other.getMetadata() != null) {
                this.metadata = other.metadata;
            }
            return this;
        }

        Builder(SubnetworkLogConfig source) {
            this.aggregationInterval = source.aggregationInterval;
            this.enable = source.enable;
            this.flowSampling = source.flowSampling;
            this.metadata = source.metadata;
        }

        public String getAggregationInterval() {
            return this.aggregationInterval;
        }

        public Builder setAggregationInterval(String aggregationInterval) {
            this.aggregationInterval = aggregationInterval;
            return this;
        }

        public Boolean getEnable() {
            return this.enable;
        }

        public Builder setEnable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public Float getFlowSampling() {
            return this.flowSampling;
        }

        public Builder setFlowSampling(Float flowSampling) {
            this.flowSampling = flowSampling;
            return this;
        }

        public String getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public SubnetworkLogConfig build() {
            return new SubnetworkLogConfig(this.aggregationInterval, this.enable, this.flowSampling, this.metadata);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAggregationInterval(this.aggregationInterval);
            newBuilder.setEnable(this.enable);
            newBuilder.setFlowSampling(this.flowSampling);
            newBuilder.setMetadata(this.metadata);
            return newBuilder;
        }
    }
}

