/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.cloud.compute.v1.HttpRedirectAction;
import com.google.cloud.compute.v1.HttpRouteAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class PathRule
implements ApiMessage {
    private final List<String> paths;
    private final HttpRouteAction routeAction;
    private final String service;
    private final HttpRedirectAction urlRedirect;
    private static final PathRule DEFAULT_INSTANCE = new PathRule();

    private PathRule() {
        this.paths = null;
        this.routeAction = null;
        this.service = null;
        this.urlRedirect = null;
    }

    private PathRule(List<String> paths, HttpRouteAction routeAction, String service, HttpRedirectAction urlRedirect) {
        this.paths = paths;
        this.routeAction = routeAction;
        this.service = service;
        this.urlRedirect = urlRedirect;
    }

    public Object getFieldValue(String fieldName) {
        if ("paths".equals(fieldName)) {
            return this.paths;
        }
        if ("routeAction".equals(fieldName)) {
            return this.routeAction;
        }
        if ("service".equals(fieldName)) {
            return this.service;
        }
        if ("urlRedirect".equals(fieldName)) {
            return this.urlRedirect;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public List<String> getPathsList() {
        return this.paths;
    }

    public HttpRouteAction getRouteAction() {
        return this.routeAction;
    }

    public String getService() {
        return this.service;
    }

    public HttpRedirectAction getUrlRedirect() {
        return this.urlRedirect;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PathRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static PathRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "PathRule{paths=" + this.paths + ", routeAction=" + this.routeAction + ", service=" + this.service + ", urlRedirect=" + this.urlRedirect + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PathRule) {
            PathRule that = (PathRule)o;
            return Objects.equals(this.paths, that.getPathsList()) && Objects.equals(this.routeAction, that.getRouteAction()) && Objects.equals(this.service, that.getService()) && Objects.equals(this.urlRedirect, that.getUrlRedirect());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.paths, this.routeAction, this.service, this.urlRedirect);
    }

    public static class Builder {
        private List<String> paths;
        private HttpRouteAction routeAction;
        private String service;
        private HttpRedirectAction urlRedirect;

        Builder() {
        }

        public Builder mergeFrom(PathRule other) {
            if (other == PathRule.getDefaultInstance()) {
                return this;
            }
            if (other.getPathsList() != null) {
                this.paths = other.paths;
            }
            if (other.getRouteAction() != null) {
                this.routeAction = other.routeAction;
            }
            if (other.getService() != null) {
                this.service = other.service;
            }
            if (other.getUrlRedirect() != null) {
                this.urlRedirect = other.urlRedirect;
            }
            return this;
        }

        Builder(PathRule source) {
            this.paths = source.paths;
            this.routeAction = source.routeAction;
            this.service = source.service;
            this.urlRedirect = source.urlRedirect;
        }

        public List<String> getPathsList() {
            return this.paths;
        }

        public Builder addAllPaths(List<String> paths) {
            if (this.paths == null) {
                this.paths = new LinkedList<String>();
            }
            this.paths.addAll(paths);
            return this;
        }

        public Builder addPaths(String paths) {
            if (this.paths == null) {
                this.paths = new LinkedList<String>();
            }
            this.paths.add(paths);
            return this;
        }

        public HttpRouteAction getRouteAction() {
            return this.routeAction;
        }

        public Builder setRouteAction(HttpRouteAction routeAction) {
            this.routeAction = routeAction;
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public HttpRedirectAction getUrlRedirect() {
            return this.urlRedirect;
        }

        public Builder setUrlRedirect(HttpRedirectAction urlRedirect) {
            this.urlRedirect = urlRedirect;
            return this;
        }

        public PathRule build() {
            return new PathRule(this.paths, this.routeAction, this.service, this.urlRedirect);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.addAllPaths(this.paths);
            newBuilder.setRouteAction(this.routeAction);
            newBuilder.setService(this.service);
            newBuilder.setUrlRedirect(this.urlRedirect);
            return newBuilder;
        }
    }
}

