/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.AggregatedListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.DeleteUrlMapHttpRequest;
import com.google.cloud.compute.v1.GetUrlMapHttpRequest;
import com.google.cloud.compute.v1.InsertUrlMapHttpRequest;
import com.google.cloud.compute.v1.InvalidateCacheUrlMapHttpRequest;
import com.google.cloud.compute.v1.ListUrlMapsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchUrlMapHttpRequest;
import com.google.cloud.compute.v1.ProjectGlobalUrlMapName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.UpdateUrlMapHttpRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapClient;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsAggregatedList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateUrlMapHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonUrlMapCallableFactory;
import com.google.cloud.compute.v1.stub.UrlMapStub;
import com.google.cloud.compute.v1.stub.UrlMapStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonUrlMapStub
extends UrlMapStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList> aggregatedListUrlMapsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.aggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/aggregated/urlMaps")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMapsAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteUrlMapHttpRequest, Operation> deleteUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetUrlMapHttpRequest, UrlMap> getUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMap.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertUrlMapHttpRequest, Operation> insertUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.invalidateCache").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}/invalidateCache")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListUrlMapsHttpRequest, UrlMapList> listUrlMapsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMapList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<PatchUrlMapHttpRequest, Operation> patchUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<UpdateUrlMapHttpRequest, Operation> updateUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.update").setHttpMethod("PUT").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.urlMaps.validate").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/urlMaps/{urlMap}/validate")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalUrlMapName.newFactory()).setResourceNameField("urlMap").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)UrlMapsValidateResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList> aggregatedListUrlMapsCallable;
    private final UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsPagedCallable;
    private final UnaryCallable<DeleteUrlMapHttpRequest, Operation> deleteUrlMapCallable;
    private final UnaryCallable<GetUrlMapHttpRequest, UrlMap> getUrlMapCallable;
    private final UnaryCallable<InsertUrlMapHttpRequest, Operation> insertUrlMapCallable;
    private final UnaryCallable<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapCallable;
    private final UnaryCallable<ListUrlMapsHttpRequest, UrlMapList> listUrlMapsCallable;
    private final UnaryCallable<ListUrlMapsHttpRequest, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsPagedCallable;
    private final UnaryCallable<PatchUrlMapHttpRequest, Operation> patchUrlMapCallable;
    private final UnaryCallable<UpdateUrlMapHttpRequest, Operation> updateUrlMapCallable;
    private final UnaryCallable<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonUrlMapStub create(UrlMapStubSettings settings) throws IOException {
        return new HttpJsonUrlMapStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonUrlMapStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonUrlMapStub(UrlMapStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonUrlMapStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonUrlMapStub(UrlMapStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonUrlMapStub(UrlMapStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonUrlMapCallableFactory());
    }

    protected HttpJsonUrlMapStub(UrlMapStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListUrlMapsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListUrlMapsMethodDescriptor).build();
        HttpJsonCallSettings deleteUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteUrlMapMethodDescriptor).build();
        HttpJsonCallSettings getUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getUrlMapMethodDescriptor).build();
        HttpJsonCallSettings insertUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertUrlMapMethodDescriptor).build();
        HttpJsonCallSettings invalidateCacheUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(invalidateCacheUrlMapMethodDescriptor).build();
        HttpJsonCallSettings listUrlMapsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listUrlMapsMethodDescriptor).build();
        HttpJsonCallSettings patchUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchUrlMapMethodDescriptor).build();
        HttpJsonCallSettings updateUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateUrlMapMethodDescriptor).build();
        HttpJsonCallSettings validateUrlMapTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateUrlMapMethodDescriptor).build();
        this.aggregatedListUrlMapsCallable = callableFactory.createUnaryCallable(aggregatedListUrlMapsTransportSettings, settings.aggregatedListUrlMapsSettings(), clientContext);
        this.aggregatedListUrlMapsPagedCallable = callableFactory.createPagedCallable(aggregatedListUrlMapsTransportSettings, settings.aggregatedListUrlMapsSettings(), clientContext);
        this.deleteUrlMapCallable = callableFactory.createUnaryCallable(deleteUrlMapTransportSettings, settings.deleteUrlMapSettings(), clientContext);
        this.getUrlMapCallable = callableFactory.createUnaryCallable(getUrlMapTransportSettings, settings.getUrlMapSettings(), clientContext);
        this.insertUrlMapCallable = callableFactory.createUnaryCallable(insertUrlMapTransportSettings, settings.insertUrlMapSettings(), clientContext);
        this.invalidateCacheUrlMapCallable = callableFactory.createUnaryCallable(invalidateCacheUrlMapTransportSettings, settings.invalidateCacheUrlMapSettings(), clientContext);
        this.listUrlMapsCallable = callableFactory.createUnaryCallable(listUrlMapsTransportSettings, settings.listUrlMapsSettings(), clientContext);
        this.listUrlMapsPagedCallable = callableFactory.createPagedCallable(listUrlMapsTransportSettings, settings.listUrlMapsSettings(), clientContext);
        this.patchUrlMapCallable = callableFactory.createUnaryCallable(patchUrlMapTransportSettings, settings.patchUrlMapSettings(), clientContext);
        this.updateUrlMapCallable = callableFactory.createUnaryCallable(updateUrlMapTransportSettings, settings.updateUrlMapSettings(), clientContext);
        this.validateUrlMapCallable = callableFactory.createUnaryCallable(validateUrlMapTransportSettings, settings.validateUrlMapSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapClient.AggregatedListUrlMapsPagedResponse> aggregatedListUrlMapsPagedCallable() {
        return this.aggregatedListUrlMapsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<AggregatedListUrlMapsHttpRequest, UrlMapsAggregatedList> aggregatedListUrlMapsCallable() {
        return this.aggregatedListUrlMapsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteUrlMapHttpRequest, Operation> deleteUrlMapCallable() {
        return this.deleteUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetUrlMapHttpRequest, UrlMap> getUrlMapCallable() {
        return this.getUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertUrlMapHttpRequest, Operation> insertUrlMapCallable() {
        return this.insertUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InvalidateCacheUrlMapHttpRequest, Operation> invalidateCacheUrlMapCallable() {
        return this.invalidateCacheUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListUrlMapsHttpRequest, UrlMapClient.ListUrlMapsPagedResponse> listUrlMapsPagedCallable() {
        return this.listUrlMapsPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListUrlMapsHttpRequest, UrlMapList> listUrlMapsCallable() {
        return this.listUrlMapsCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<PatchUrlMapHttpRequest, Operation> patchUrlMapCallable() {
        return this.patchUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<UpdateUrlMapHttpRequest, Operation> updateUrlMapCallable() {
        return this.updateUrlMapCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ValidateUrlMapHttpRequest, UrlMapsValidateResponse> validateUrlMapCallable() {
        return this.validateUrlMapCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

