/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.DeleteImageHttpRequest;
import com.google.cloud.compute.v1.DeprecateImageHttpRequest;
import com.google.cloud.compute.v1.GetFromFamilyImageHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicyImageHttpRequest;
import com.google.cloud.compute.v1.GetImageHttpRequest;
import com.google.cloud.compute.v1.Image;
import com.google.cloud.compute.v1.ImageClient;
import com.google.cloud.compute.v1.ImageList;
import com.google.cloud.compute.v1.InsertImageHttpRequest;
import com.google.cloud.compute.v1.ListImagesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ProjectGlobalImageFamilyName;
import com.google.cloud.compute.v1.ProjectGlobalImageName;
import com.google.cloud.compute.v1.ProjectGlobalImageResourceName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.SetIamPolicyImageHttpRequest;
import com.google.cloud.compute.v1.SetLabelsImageHttpRequest;
import com.google.cloud.compute.v1.TestIamPermissionsImageHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonImageCallableFactory;
import com.google.cloud.compute.v1.stub.ImageStub;
import com.google.cloud.compute.v1.stub.ImageStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonImageStub
extends ImageStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteImageHttpRequest, Operation> deleteImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{image}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalImageName.newFactory()).setResourceNameField("image").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeprecateImageHttpRequest, Operation> deprecateImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.deprecate").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{image}/deprecate")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalImageName.newFactory()).setResourceNameField("image").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetImageHttpRequest, Image> getImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{image}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageName.newFactory()).setResourceNameField("image").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Image.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.getFromFamily").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/family/{family}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageFamilyName.newFactory()).setResourceNameField("family").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Image.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyImageHttpRequest, Policy> getIamPolicyImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.getIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{resource}/getIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertImageHttpRequest, Operation> insertImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"forceCreate", "requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListImagesHttpRequest, ImageList> listImagesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ImageList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyImageHttpRequest, Policy> setIamPolicyImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.setIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{resource}/setIamPolicy")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetLabelsImageHttpRequest, Operation> setLabelsImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.setLabels").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{resource}/setLabels")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsImageHttpRequest, TestPermissionsResponse> testIamPermissionsImageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.images.testIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/images/{resource}/testIamPermissions")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalImageResourceName.newFactory()).setResourceNameField("resource").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteImageHttpRequest, Operation> deleteImageCallable;
    private final UnaryCallable<DeprecateImageHttpRequest, Operation> deprecateImageCallable;
    private final UnaryCallable<GetImageHttpRequest, Image> getImageCallable;
    private final UnaryCallable<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageCallable;
    private final UnaryCallable<GetIamPolicyImageHttpRequest, Policy> getIamPolicyImageCallable;
    private final UnaryCallable<InsertImageHttpRequest, Operation> insertImageCallable;
    private final UnaryCallable<ListImagesHttpRequest, ImageList> listImagesCallable;
    private final UnaryCallable<ListImagesHttpRequest, ImageClient.ListImagesPagedResponse> listImagesPagedCallable;
    private final UnaryCallable<SetIamPolicyImageHttpRequest, Policy> setIamPolicyImageCallable;
    private final UnaryCallable<SetLabelsImageHttpRequest, Operation> setLabelsImageCallable;
    private final UnaryCallable<TestIamPermissionsImageHttpRequest, TestPermissionsResponse> testIamPermissionsImageCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonImageStub create(ImageStubSettings settings) throws IOException {
        return new HttpJsonImageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonImageStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonImageStub(ImageStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonImageStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonImageStub(ImageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonImageStub(ImageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonImageCallableFactory());
    }

    protected HttpJsonImageStub(ImageStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteImageMethodDescriptor).build();
        HttpJsonCallSettings deprecateImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deprecateImageMethodDescriptor).build();
        HttpJsonCallSettings getImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getImageMethodDescriptor).build();
        HttpJsonCallSettings getFromFamilyImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFromFamilyImageMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyImageMethodDescriptor).build();
        HttpJsonCallSettings insertImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertImageMethodDescriptor).build();
        HttpJsonCallSettings listImagesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listImagesMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyImageMethodDescriptor).build();
        HttpJsonCallSettings setLabelsImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setLabelsImageMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsImageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsImageMethodDescriptor).build();
        this.deleteImageCallable = callableFactory.createUnaryCallable(deleteImageTransportSettings, settings.deleteImageSettings(), clientContext);
        this.deprecateImageCallable = callableFactory.createUnaryCallable(deprecateImageTransportSettings, settings.deprecateImageSettings(), clientContext);
        this.getImageCallable = callableFactory.createUnaryCallable(getImageTransportSettings, settings.getImageSettings(), clientContext);
        this.getFromFamilyImageCallable = callableFactory.createUnaryCallable(getFromFamilyImageTransportSettings, settings.getFromFamilyImageSettings(), clientContext);
        this.getIamPolicyImageCallable = callableFactory.createUnaryCallable(getIamPolicyImageTransportSettings, settings.getIamPolicyImageSettings(), clientContext);
        this.insertImageCallable = callableFactory.createUnaryCallable(insertImageTransportSettings, settings.insertImageSettings(), clientContext);
        this.listImagesCallable = callableFactory.createUnaryCallable(listImagesTransportSettings, settings.listImagesSettings(), clientContext);
        this.listImagesPagedCallable = callableFactory.createPagedCallable(listImagesTransportSettings, settings.listImagesSettings(), clientContext);
        this.setIamPolicyImageCallable = callableFactory.createUnaryCallable(setIamPolicyImageTransportSettings, settings.setIamPolicyImageSettings(), clientContext);
        this.setLabelsImageCallable = callableFactory.createUnaryCallable(setLabelsImageTransportSettings, settings.setLabelsImageSettings(), clientContext);
        this.testIamPermissionsImageCallable = callableFactory.createUnaryCallable(testIamPermissionsImageTransportSettings, settings.testIamPermissionsImageSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteImageHttpRequest, Operation> deleteImageCallable() {
        return this.deleteImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<DeprecateImageHttpRequest, Operation> deprecateImageCallable() {
        return this.deprecateImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetImageHttpRequest, Image> getImageCallable() {
        return this.getImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetFromFamilyImageHttpRequest, Image> getFromFamilyImageCallable() {
        return this.getFromFamilyImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetIamPolicyImageHttpRequest, Policy> getIamPolicyImageCallable() {
        return this.getIamPolicyImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertImageHttpRequest, Operation> insertImageCallable() {
        return this.insertImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListImagesHttpRequest, ImageClient.ListImagesPagedResponse> listImagesPagedCallable() {
        return this.listImagesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListImagesHttpRequest, ImageList> listImagesCallable() {
        return this.listImagesCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetIamPolicyImageHttpRequest, Policy> setIamPolicyImageCallable() {
        return this.setIamPolicyImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<SetLabelsImageHttpRequest, Operation> setLabelsImageCallable() {
        return this.setLabelsImageCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<TestIamPermissionsImageHttpRequest, TestPermissionsResponse> testIamPermissionsImageCallable() {
        return this.testIamPermissionsImageCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

