/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class TargetVpnGateway
implements ApiMessage {
    private final String creationTimestamp;
    private final String description;
    private final List<String> forwardingRules;
    private final String id;
    private final String kind;
    private final String name;
    private final String network;
    private final String region;
    private final String selfLink;
    private final String status;
    private final List<String> tunnels;
    private static final TargetVpnGateway DEFAULT_INSTANCE = new TargetVpnGateway();

    private TargetVpnGateway() {
        this.creationTimestamp = null;
        this.description = null;
        this.forwardingRules = null;
        this.id = null;
        this.kind = null;
        this.name = null;
        this.network = null;
        this.region = null;
        this.selfLink = null;
        this.status = null;
        this.tunnels = null;
    }

    private TargetVpnGateway(String creationTimestamp, String description, List<String> forwardingRules, String id, String kind, String name, String network, String region, String selfLink, String status, List<String> tunnels) {
        this.creationTimestamp = creationTimestamp;
        this.description = description;
        this.forwardingRules = forwardingRules;
        this.id = id;
        this.kind = kind;
        this.name = name;
        this.network = network;
        this.region = region;
        this.selfLink = selfLink;
        this.status = status;
        this.tunnels = tunnels;
    }

    public Object getFieldValue(String fieldName) {
        if ("creationTimestamp".equals(fieldName)) {
            return this.creationTimestamp;
        }
        if ("description".equals(fieldName)) {
            return this.description;
        }
        if ("forwardingRules".equals(fieldName)) {
            return this.forwardingRules;
        }
        if ("id".equals(fieldName)) {
            return this.id;
        }
        if ("kind".equals(fieldName)) {
            return this.kind;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("region".equals(fieldName)) {
            return this.region;
        }
        if ("selfLink".equals(fieldName)) {
            return this.selfLink;
        }
        if ("status".equals(fieldName)) {
            return this.status;
        }
        if ("tunnels".equals(fieldName)) {
            return this.tunnels;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getForwardingRulesList() {
        return this.forwardingRules;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getStatus() {
        return this.status;
    }

    public List<String> getTunnelsList() {
        return this.tunnels;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TargetVpnGateway prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static TargetVpnGateway getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "TargetVpnGateway{creationTimestamp=" + this.creationTimestamp + ", description=" + this.description + ", forwardingRules=" + this.forwardingRules + ", id=" + this.id + ", kind=" + this.kind + ", name=" + this.name + ", network=" + this.network + ", region=" + this.region + ", selfLink=" + this.selfLink + ", status=" + this.status + ", tunnels=" + this.tunnels + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TargetVpnGateway) {
            TargetVpnGateway that = (TargetVpnGateway)o;
            return Objects.equals(this.creationTimestamp, that.getCreationTimestamp()) && Objects.equals(this.description, that.getDescription()) && Objects.equals(this.forwardingRules, that.getForwardingRulesList()) && Objects.equals(this.id, that.getId()) && Objects.equals(this.kind, that.getKind()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.selfLink, that.getSelfLink()) && Objects.equals(this.status, that.getStatus()) && Objects.equals(this.tunnels, that.getTunnelsList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creationTimestamp, this.description, this.forwardingRules, this.id, this.kind, this.name, this.network, this.region, this.selfLink, this.status, this.tunnels);
    }

    public static class Builder {
        private String creationTimestamp;
        private String description;
        private List<String> forwardingRules;
        private String id;
        private String kind;
        private String name;
        private String network;
        private String region;
        private String selfLink;
        private String status;
        private List<String> tunnels;

        Builder() {
        }

        public Builder mergeFrom(TargetVpnGateway other) {
            if (other == TargetVpnGateway.getDefaultInstance()) {
                return this;
            }
            if (other.getCreationTimestamp() != null) {
                this.creationTimestamp = other.creationTimestamp;
            }
            if (other.getDescription() != null) {
                this.description = other.description;
            }
            if (other.getForwardingRulesList() != null) {
                this.forwardingRules = other.forwardingRules;
            }
            if (other.getId() != null) {
                this.id = other.id;
            }
            if (other.getKind() != null) {
                this.kind = other.kind;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getRegion() != null) {
                this.region = other.region;
            }
            if (other.getSelfLink() != null) {
                this.selfLink = other.selfLink;
            }
            if (other.getStatus() != null) {
                this.status = other.status;
            }
            if (other.getTunnelsList() != null) {
                this.tunnels = other.tunnels;
            }
            return this;
        }

        Builder(TargetVpnGateway source) {
            this.creationTimestamp = source.creationTimestamp;
            this.description = source.description;
            this.forwardingRules = source.forwardingRules;
            this.id = source.id;
            this.kind = source.kind;
            this.name = source.name;
            this.network = source.network;
            this.region = source.region;
            this.selfLink = source.selfLink;
            this.status = source.status;
            this.tunnels = source.tunnels;
        }

        public String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public Builder setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public List<String> getForwardingRulesList() {
            return this.forwardingRules;
        }

        public Builder addAllForwardingRules(List<String> forwardingRules) {
            if (this.forwardingRules == null) {
                this.forwardingRules = new LinkedList<String>();
            }
            this.forwardingRules.addAll(forwardingRules);
            return this;
        }

        public Builder addForwardingRules(String forwardingRules) {
            if (this.forwardingRules == null) {
                this.forwardingRules = new LinkedList<String>();
            }
            this.forwardingRules.add(forwardingRules);
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getKind() {
            return this.kind;
        }

        public Builder setKind(String kind) {
            this.kind = kind;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getRegion() {
            return this.region;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public String getSelfLink() {
            return this.selfLink;
        }

        public Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public List<String> getTunnelsList() {
            return this.tunnels;
        }

        public Builder addAllTunnels(List<String> tunnels) {
            if (this.tunnels == null) {
                this.tunnels = new LinkedList<String>();
            }
            this.tunnels.addAll(tunnels);
            return this;
        }

        public Builder addTunnels(String tunnels) {
            if (this.tunnels == null) {
                this.tunnels = new LinkedList<String>();
            }
            this.tunnels.add(tunnels);
            return this;
        }

        public TargetVpnGateway build() {
            return new TargetVpnGateway(this.creationTimestamp, this.description, this.forwardingRules, this.id, this.kind, this.name, this.network, this.region, this.selfLink, this.status, this.tunnels);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setCreationTimestamp(this.creationTimestamp);
            newBuilder.setDescription(this.description);
            newBuilder.addAllForwardingRules(this.forwardingRules);
            newBuilder.setId(this.id);
            newBuilder.setKind(this.kind);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setRegion(this.region);
            newBuilder.setSelfLink(this.selfLink);
            newBuilder.setStatus(this.status);
            newBuilder.addAllTunnels(this.tunnels);
            return newBuilder;
        }
    }
}

