/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class NetworkPeering
implements ApiMessage {
    private final Boolean autoCreateRoutes;
    private final Boolean exchangeSubnetRoutes;
    private final Boolean exportCustomRoutes;
    private final Boolean importCustomRoutes;
    private final String name;
    private final String network;
    private final String state;
    private final String stateDetails;
    private static final NetworkPeering DEFAULT_INSTANCE = new NetworkPeering();

    private NetworkPeering() {
        this.autoCreateRoutes = null;
        this.exchangeSubnetRoutes = null;
        this.exportCustomRoutes = null;
        this.importCustomRoutes = null;
        this.name = null;
        this.network = null;
        this.state = null;
        this.stateDetails = null;
    }

    private NetworkPeering(Boolean autoCreateRoutes, Boolean exchangeSubnetRoutes, Boolean exportCustomRoutes, Boolean importCustomRoutes, String name, String network, String state, String stateDetails) {
        this.autoCreateRoutes = autoCreateRoutes;
        this.exchangeSubnetRoutes = exchangeSubnetRoutes;
        this.exportCustomRoutes = exportCustomRoutes;
        this.importCustomRoutes = importCustomRoutes;
        this.name = name;
        this.network = network;
        this.state = state;
        this.stateDetails = stateDetails;
    }

    public Object getFieldValue(String fieldName) {
        if ("autoCreateRoutes".equals(fieldName)) {
            return this.autoCreateRoutes;
        }
        if ("exchangeSubnetRoutes".equals(fieldName)) {
            return this.exchangeSubnetRoutes;
        }
        if ("exportCustomRoutes".equals(fieldName)) {
            return this.exportCustomRoutes;
        }
        if ("importCustomRoutes".equals(fieldName)) {
            return this.importCustomRoutes;
        }
        if ("name".equals(fieldName)) {
            return this.name;
        }
        if ("network".equals(fieldName)) {
            return this.network;
        }
        if ("state".equals(fieldName)) {
            return this.state;
        }
        if ("stateDetails".equals(fieldName)) {
            return this.stateDetails;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public Boolean getAutoCreateRoutes() {
        return this.autoCreateRoutes;
    }

    public Boolean getExchangeSubnetRoutes() {
        return this.exchangeSubnetRoutes;
    }

    public Boolean getExportCustomRoutes() {
        return this.exportCustomRoutes;
    }

    public Boolean getImportCustomRoutes() {
        return this.importCustomRoutes;
    }

    public String getName() {
        return this.name;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getState() {
        return this.state;
    }

    public String getStateDetails() {
        return this.stateDetails;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkPeering prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static NetworkPeering getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "NetworkPeering{autoCreateRoutes=" + this.autoCreateRoutes + ", exchangeSubnetRoutes=" + this.exchangeSubnetRoutes + ", exportCustomRoutes=" + this.exportCustomRoutes + ", importCustomRoutes=" + this.importCustomRoutes + ", name=" + this.name + ", network=" + this.network + ", state=" + this.state + ", stateDetails=" + this.stateDetails + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NetworkPeering) {
            NetworkPeering that = (NetworkPeering)o;
            return Objects.equals(this.autoCreateRoutes, that.getAutoCreateRoutes()) && Objects.equals(this.exchangeSubnetRoutes, that.getExchangeSubnetRoutes()) && Objects.equals(this.exportCustomRoutes, that.getExportCustomRoutes()) && Objects.equals(this.importCustomRoutes, that.getImportCustomRoutes()) && Objects.equals(this.name, that.getName()) && Objects.equals(this.network, that.getNetwork()) && Objects.equals(this.state, that.getState()) && Objects.equals(this.stateDetails, that.getStateDetails());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.autoCreateRoutes, this.exchangeSubnetRoutes, this.exportCustomRoutes, this.importCustomRoutes, this.name, this.network, this.state, this.stateDetails);
    }

    public static class Builder {
        private Boolean autoCreateRoutes;
        private Boolean exchangeSubnetRoutes;
        private Boolean exportCustomRoutes;
        private Boolean importCustomRoutes;
        private String name;
        private String network;
        private String state;
        private String stateDetails;

        Builder() {
        }

        public Builder mergeFrom(NetworkPeering other) {
            if (other == NetworkPeering.getDefaultInstance()) {
                return this;
            }
            if (other.getAutoCreateRoutes() != null) {
                this.autoCreateRoutes = other.autoCreateRoutes;
            }
            if (other.getExchangeSubnetRoutes() != null) {
                this.exchangeSubnetRoutes = other.exchangeSubnetRoutes;
            }
            if (other.getExportCustomRoutes() != null) {
                this.exportCustomRoutes = other.exportCustomRoutes;
            }
            if (other.getImportCustomRoutes() != null) {
                this.importCustomRoutes = other.importCustomRoutes;
            }
            if (other.getName() != null) {
                this.name = other.name;
            }
            if (other.getNetwork() != null) {
                this.network = other.network;
            }
            if (other.getState() != null) {
                this.state = other.state;
            }
            if (other.getStateDetails() != null) {
                this.stateDetails = other.stateDetails;
            }
            return this;
        }

        Builder(NetworkPeering source) {
            this.autoCreateRoutes = source.autoCreateRoutes;
            this.exchangeSubnetRoutes = source.exchangeSubnetRoutes;
            this.exportCustomRoutes = source.exportCustomRoutes;
            this.importCustomRoutes = source.importCustomRoutes;
            this.name = source.name;
            this.network = source.network;
            this.state = source.state;
            this.stateDetails = source.stateDetails;
        }

        public Boolean getAutoCreateRoutes() {
            return this.autoCreateRoutes;
        }

        public Builder setAutoCreateRoutes(Boolean autoCreateRoutes) {
            this.autoCreateRoutes = autoCreateRoutes;
            return this;
        }

        public Boolean getExchangeSubnetRoutes() {
            return this.exchangeSubnetRoutes;
        }

        public Builder setExchangeSubnetRoutes(Boolean exchangeSubnetRoutes) {
            this.exchangeSubnetRoutes = exchangeSubnetRoutes;
            return this;
        }

        public Boolean getExportCustomRoutes() {
            return this.exportCustomRoutes;
        }

        public Builder setExportCustomRoutes(Boolean exportCustomRoutes) {
            this.exportCustomRoutes = exportCustomRoutes;
            return this;
        }

        public Boolean getImportCustomRoutes() {
            return this.importCustomRoutes;
        }

        public Builder setImportCustomRoutes(Boolean importCustomRoutes) {
            this.importCustomRoutes = importCustomRoutes;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getNetwork() {
            return this.network;
        }

        public Builder setNetwork(String network) {
            this.network = network;
            return this;
        }

        public String getState() {
            return this.state;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public String getStateDetails() {
            return this.stateDetails;
        }

        public Builder setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public NetworkPeering build() {
            return new NetworkPeering(this.autoCreateRoutes, this.exchangeSubnetRoutes, this.exportCustomRoutes, this.importCustomRoutes, this.name, this.network, this.state, this.stateDetails);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setAutoCreateRoutes(this.autoCreateRoutes);
            newBuilder.setExchangeSubnetRoutes(this.exchangeSubnetRoutes);
            newBuilder.setExportCustomRoutes(this.exportCustomRoutes);
            newBuilder.setImportCustomRoutes(this.importCustomRoutes);
            newBuilder.setName(this.name);
            newBuilder.setNetwork(this.network);
            newBuilder.setState(this.state);
            newBuilder.setStateDetails(this.stateDetails);
            return newBuilder;
        }
    }
}

