/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.ZoneId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Region
implements Serializable {
    static final Function<com.google.api.services.compute.model.Region, Region> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.Region, Region>(){

        public Region apply(com.google.api.services.compute.model.Region pb) {
            return Region.fromPb(pb);
        }
    };
    static final Function<Region, com.google.api.services.compute.model.Region> TO_PB_FUNCTION = new Function<Region, com.google.api.services.compute.model.Region>(){

        public com.google.api.services.compute.model.Region apply(Region region) {
            return region.toPb();
        }
    };
    private static final long serialVersionUID = -3578710133393645135L;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private final RegionId regionId;
    private final String generatedId;
    private final Long creationTimestamp;
    private final String description;
    private final Status status;
    private final List<ZoneId> zones;
    private final List<Quota> quotas;
    private final DeprecationStatus<RegionId> deprecationStatus;

    private Region(Builder builder) {
        this.regionId = builder.regionId;
        this.generatedId = builder.generatedId;
        this.creationTimestamp = builder.creationTimestamp;
        this.description = builder.description;
        this.status = builder.status;
        this.zones = builder.zones;
        this.quotas = builder.quotas;
        this.deprecationStatus = builder.deprecationStatus;
    }

    public RegionId getRegionId() {
        return this.regionId;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<ZoneId> getZones() {
        return this.zones;
    }

    public List<Quota> getQuotas() {
        return this.quotas;
    }

    public DeprecationStatus<RegionId> getDeprecationStatus() {
        return this.deprecationStatus;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("regionId", (Object)this.regionId).add("generatedId", (Object)this.generatedId).add("creationTimestamp", (Object)this.creationTimestamp).add("description", (Object)this.description).add("status", (Object)this.status).add("zones", this.zones).add("quotas", this.quotas).add("deprecationStatus", this.deprecationStatus).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.regionId);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(Region.class) && Objects.equals(this.toPb(), ((Region)obj).toPb());
    }

    com.google.api.services.compute.model.Region toPb() {
        com.google.api.services.compute.model.Region regionPb = new com.google.api.services.compute.model.Region();
        if (this.generatedId != null) {
            regionPb.setId(new BigInteger(this.generatedId));
        }
        if (this.creationTimestamp != null) {
            regionPb.setCreationTimestamp(TIMESTAMP_FORMATTER.print(this.creationTimestamp.longValue()));
        }
        regionPb.setName(this.regionId.getRegion());
        regionPb.setDescription(this.description);
        regionPb.setSelfLink(this.regionId.getSelfLink());
        if (this.status != null) {
            regionPb.setStatus(this.status.name());
        }
        if (this.zones != null) {
            regionPb.setZones(Lists.transform(this.zones, ZoneId.TO_URL_FUNCTION));
        }
        if (this.quotas != null) {
            regionPb.setQuotas(Lists.transform(this.quotas, Quota.TO_PB_FUNCTION));
        }
        if (this.deprecationStatus != null) {
            regionPb.setDeprecated(this.deprecationStatus.toPb());
        }
        return regionPb;
    }

    static Builder builder() {
        return new Builder();
    }

    static Region fromPb(com.google.api.services.compute.model.Region regionPb) {
        Builder builder = Region.builder();
        builder.setRegionId(RegionId.fromUrl(regionPb.getSelfLink()));
        if (regionPb.getId() != null) {
            builder.setGeneratedId(regionPb.getId().toString());
        }
        if (regionPb.getCreationTimestamp() != null) {
            builder.setCreationTimestamp(TIMESTAMP_FORMATTER.parseMillis(regionPb.getCreationTimestamp()));
        }
        builder.setDescription(regionPb.getDescription());
        if (regionPb.getStatus() != null) {
            builder.setStatus(Status.valueOf(regionPb.getStatus()));
        }
        if (regionPb.getZones() != null) {
            builder.setZones(Lists.transform((List)regionPb.getZones(), ZoneId.FROM_URL_FUNCTION));
        }
        if (regionPb.getQuotas() != null) {
            builder.setQuotas(Lists.transform((List)regionPb.getQuotas(), Quota.FROM_PB_FUNCTION));
        }
        if (regionPb.getDeprecated() != null) {
            builder.setDeprecationStatus(DeprecationStatus.fromPb(regionPb.getDeprecated(), RegionId.FROM_URL_FUNCTION));
        }
        return builder.build();
    }

    static final class Builder {
        private RegionId regionId;
        private String generatedId;
        private Long creationTimestamp;
        private String description;
        private Status status;
        private List<ZoneId> zones;
        private List<Quota> quotas;
        private DeprecationStatus<RegionId> deprecationStatus;

        private Builder() {
        }

        Builder setRegionId(RegionId regionId) {
            this.regionId = regionId;
            return this;
        }

        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        Builder setZones(List<ZoneId> zones) {
            this.zones = ImmutableList.copyOf(zones);
            return this;
        }

        Builder setQuotas(List<Quota> quotas) {
            this.quotas = ImmutableList.copyOf(quotas);
            return this;
        }

        Builder setDeprecationStatus(DeprecationStatus<RegionId> deprecationStatus) {
            this.deprecationStatus = deprecationStatus;
            return this;
        }

        Region build() {
            return new Region(this);
        }
    }

    public static final class Quota
    implements Serializable {
        static final Function<com.google.api.services.compute.model.Quota, Quota> FROM_PB_FUNCTION = new Function<com.google.api.services.compute.model.Quota, Quota>(){

            public Quota apply(com.google.api.services.compute.model.Quota pb) {
                return Quota.fromPb(pb);
            }
        };
        static final Function<Quota, com.google.api.services.compute.model.Quota> TO_PB_FUNCTION = new Function<Quota, com.google.api.services.compute.model.Quota>(){

            public com.google.api.services.compute.model.Quota apply(Quota quota) {
                return quota.toPb();
            }
        };
        private static final long serialVersionUID = -4357118665133226338L;
        private final String metric;
        private final double limit;
        private final double usage;

        Quota(String metric, double limit, double usage) {
            this.metric = metric;
            this.limit = limit;
            this.usage = usage;
        }

        public String getMetric() {
            return this.metric;
        }

        public double getLimit() {
            return this.limit;
        }

        public double getUsage() {
            return this.usage;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("metric", (Object)this.metric).add("limit", this.limit).add("usage", this.usage).toString();
        }

        public int hashCode() {
            return Objects.hash(this.metric, this.limit, this.usage);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Quota)) {
                return false;
            }
            Quota other = (Quota)obj;
            return Objects.equals(this.metric, other.metric) && Objects.equals(this.limit, other.limit) && Objects.equals(this.usage, other.usage);
        }

        com.google.api.services.compute.model.Quota toPb() {
            return new com.google.api.services.compute.model.Quota().setMetric(this.metric).setLimit(Double.valueOf(this.limit)).setUsage(Double.valueOf(this.usage));
        }

        static Quota fromPb(com.google.api.services.compute.model.Quota quotaPb) {
            return new Quota(quotaPb.getMetric(), quotaPb.getLimit(), quotaPb.getUsage());
        }
    }

    public static enum Status {
        UP,
        DOWN;

    }
}

