/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListRegionCommitmentsHttpRequest;
import com.google.cloud.compute.v1.Commitment;
import com.google.cloud.compute.v1.CommitmentAggregatedList;
import com.google.cloud.compute.v1.CommitmentList;
import com.google.cloud.compute.v1.CommitmentsScopedList;
import com.google.cloud.compute.v1.GetRegionCommitmentHttpRequest;
import com.google.cloud.compute.v1.InsertRegionCommitmentHttpRequest;
import com.google.cloud.compute.v1.ListRegionCommitmentsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionCommitmentClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionCommitmentStub;
import com.google.cloud.compute.v1.stub.RegionCommitmentStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionCommitmentStubSettings
extends StubSettings<RegionCommitmentStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> aggregatedListRegionCommitmentsSettings;
    private final UnaryCallSettings<GetRegionCommitmentHttpRequest, Commitment> getRegionCommitmentSettings;
    private final UnaryCallSettings<InsertRegionCommitmentHttpRequest, Operation> insertRegionCommitmentSettings;
    private final PagedCallSettings<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse> listRegionCommitmentsSettings;
    private static final PagedListDescriptor<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList> AGGREGATED_LIST_REGION_COMMITMENTS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListRegionCommitmentsHttpRequest injectToken(AggregatedListRegionCommitmentsHttpRequest payload, String token) {
            return AggregatedListRegionCommitmentsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListRegionCommitmentsHttpRequest injectPageSize(AggregatedListRegionCommitmentsHttpRequest payload, int pageSize) {
            return AggregatedListRegionCommitmentsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListRegionCommitmentsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(CommitmentAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CommitmentsScopedList> extractResources(CommitmentAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment> LIST_REGION_COMMITMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionCommitmentsHttpRequest injectToken(ListRegionCommitmentsHttpRequest payload, String token) {
            return ListRegionCommitmentsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionCommitmentsHttpRequest injectPageSize(ListRegionCommitmentsHttpRequest payload, int pageSize) {
            return ListRegionCommitmentsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionCommitmentsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(CommitmentList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Commitment> extractResources(CommitmentList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> AGGREGATED_LIST_REGION_COMMITMENTS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse>(){

        public ApiFuture<RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList> callable, AggregatedListRegionCommitmentsHttpRequest request, ApiCallContext context, ApiFuture<CommitmentAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_REGION_COMMITMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse.createAsync((PageContext<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, CommitmentsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse> LIST_REGION_COMMITMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse>(){

        public ApiFuture<RegionCommitmentClient.ListRegionCommitmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionCommitmentsHttpRequest, CommitmentList> callable, ListRegionCommitmentsHttpRequest request, ApiCallContext context, ApiFuture<CommitmentList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_COMMITMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionCommitmentClient.ListRegionCommitmentsPagedResponse.createAsync((PageContext<ListRegionCommitmentsHttpRequest, CommitmentList, Commitment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> aggregatedListRegionCommitmentsSettings() {
        return this.aggregatedListRegionCommitmentsSettings;
    }

    public UnaryCallSettings<GetRegionCommitmentHttpRequest, Commitment> getRegionCommitmentSettings() {
        return this.getRegionCommitmentSettings;
    }

    public UnaryCallSettings<InsertRegionCommitmentHttpRequest, Operation> insertRegionCommitmentSettings() {
        return this.insertRegionCommitmentSettings;
    }

    public PagedCallSettings<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse> listRegionCommitmentsSettings() {
        return this.listRegionCommitmentsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionCommitmentStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionCommitmentStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionCommitmentStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionCommitmentStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionCommitmentStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListRegionCommitmentsSettings = settingsBuilder.aggregatedListRegionCommitmentsSettings().build();
        this.getRegionCommitmentSettings = settingsBuilder.getRegionCommitmentSettings().build();
        this.insertRegionCommitmentSettings = settingsBuilder.insertRegionCommitmentSettings().build();
        this.listRegionCommitmentsSettings = settingsBuilder.listRegionCommitmentsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionCommitmentStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> aggregatedListRegionCommitmentsSettings;
        private final UnaryCallSettings.Builder<GetRegionCommitmentHttpRequest, Commitment> getRegionCommitmentSettings;
        private final UnaryCallSettings.Builder<InsertRegionCommitmentHttpRequest, Operation> insertRegionCommitmentSettings;
        private final PagedCallSettings.Builder<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse> listRegionCommitmentsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListRegionCommitmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_REGION_COMMITMENTS_PAGE_STR_FACT);
            this.getRegionCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertRegionCommitmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionCommitmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_COMMITMENTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListRegionCommitmentsSettings, this.getRegionCommitmentSettings, this.insertRegionCommitmentSettings, this.listRegionCommitmentsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionCommitmentStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionCommitmentStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionCommitmentStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionCommitmentStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListRegionCommitmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertRegionCommitmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionCommitmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionCommitmentStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListRegionCommitmentsSettings = settings.aggregatedListRegionCommitmentsSettings.toBuilder();
            this.getRegionCommitmentSettings = settings.getRegionCommitmentSettings.toBuilder();
            this.insertRegionCommitmentSettings = settings.insertRegionCommitmentSettings.toBuilder();
            this.listRegionCommitmentsSettings = settings.listRegionCommitmentsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListRegionCommitmentsSettings, this.getRegionCommitmentSettings, this.insertRegionCommitmentSettings, this.listRegionCommitmentsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListRegionCommitmentsHttpRequest, CommitmentAggregatedList, RegionCommitmentClient.AggregatedListRegionCommitmentsPagedResponse> aggregatedListRegionCommitmentsSettings() {
            return this.aggregatedListRegionCommitmentsSettings;
        }

        public UnaryCallSettings.Builder<GetRegionCommitmentHttpRequest, Commitment> getRegionCommitmentSettings() {
            return this.getRegionCommitmentSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionCommitmentHttpRequest, Operation> insertRegionCommitmentSettings() {
            return this.insertRegionCommitmentSettings;
        }

        public PagedCallSettings.Builder<ListRegionCommitmentsHttpRequest, CommitmentList, RegionCommitmentClient.ListRegionCommitmentsPagedResponse> listRegionCommitmentsSettings() {
            return this.listRegionCommitmentsSettings;
        }

        public RegionCommitmentStubSettings build() throws IOException {
            return new RegionCommitmentStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

