/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.DeleteInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagerAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupManagerClient;
import com.google.cloud.compute.v1.InstanceGroupManagerList;
import com.google.cloud.compute.v1.InstanceGroupManagersListManagedInstancesResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersScopedList;
import com.google.cloud.compute.v1.ListInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.ListManagedInstancesInstanceGroupManagersHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.RecreateInstancesInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.ResizeInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.SetTargetPoolsInstanceGroupManagerHttpRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceGroupManagerStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class InstanceGroupManagerStubSettings
extends StubSettings<InstanceGroupManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<AbandonInstancesInstanceGroupManagerHttpRequest, Operation> abandonInstancesInstanceGroupManagerSettings;
    private final PagedCallSettings<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> aggregatedListInstanceGroupManagersSettings;
    private final UnaryCallSettings<DeleteInstanceGroupManagerHttpRequest, Operation> deleteInstanceGroupManagerSettings;
    private final UnaryCallSettings<DeleteInstancesInstanceGroupManagerHttpRequest, Operation> deleteInstancesInstanceGroupManagerSettings;
    private final UnaryCallSettings<GetInstanceGroupManagerHttpRequest, InstanceGroupManager> getInstanceGroupManagerSettings;
    private final UnaryCallSettings<InsertInstanceGroupManagerHttpRequest, Operation> insertInstanceGroupManagerSettings;
    private final PagedCallSettings<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> listInstanceGroupManagersSettings;
    private final UnaryCallSettings<ListManagedInstancesInstanceGroupManagersHttpRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesInstanceGroupManagersSettings;
    private final UnaryCallSettings<PatchInstanceGroupManagerHttpRequest, Operation> patchInstanceGroupManagerSettings;
    private final UnaryCallSettings<RecreateInstancesInstanceGroupManagerHttpRequest, Operation> recreateInstancesInstanceGroupManagerSettings;
    private final UnaryCallSettings<ResizeInstanceGroupManagerHttpRequest, Operation> resizeInstanceGroupManagerSettings;
    private final UnaryCallSettings<SetInstanceTemplateInstanceGroupManagerHttpRequest, Operation> setInstanceTemplateInstanceGroupManagerSettings;
    private final UnaryCallSettings<SetTargetPoolsInstanceGroupManagerHttpRequest, Operation> setTargetPoolsInstanceGroupManagerSettings;
    private static final PagedListDescriptor<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList> AGGREGATED_LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstanceGroupManagersHttpRequest injectToken(AggregatedListInstanceGroupManagersHttpRequest payload, String token) {
            return AggregatedListInstanceGroupManagersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListInstanceGroupManagersHttpRequest injectPageSize(AggregatedListInstanceGroupManagersHttpRequest payload, int pageSize) {
            return AggregatedListInstanceGroupManagersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstanceGroupManagersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagerAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroupManagersScopedList> extractResources(InstanceGroupManagerAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager> LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceGroupManagersHttpRequest injectToken(ListInstanceGroupManagersHttpRequest payload, String token) {
            return ListInstanceGroupManagersHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListInstanceGroupManagersHttpRequest injectPageSize(ListInstanceGroupManagersHttpRequest payload, int pageSize) {
            return ListInstanceGroupManagersHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceGroupManagersHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroupManager> extractResources(InstanceGroupManagerList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> AGGREGATED_LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse>(){

        public ApiFuture<InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList> callable, AggregatedListInstanceGroupManagersHttpRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse.createAsync((PageContext<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse>(){

        public ApiFuture<InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList> callable, ListInstanceGroupManagersHttpRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse.createAsync((PageContext<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManager>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AbandonInstancesInstanceGroupManagerHttpRequest, Operation> abandonInstancesInstanceGroupManagerSettings() {
        return this.abandonInstancesInstanceGroupManagerSettings;
    }

    public PagedCallSettings<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> aggregatedListInstanceGroupManagersSettings() {
        return this.aggregatedListInstanceGroupManagersSettings;
    }

    public UnaryCallSettings<DeleteInstanceGroupManagerHttpRequest, Operation> deleteInstanceGroupManagerSettings() {
        return this.deleteInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<DeleteInstancesInstanceGroupManagerHttpRequest, Operation> deleteInstancesInstanceGroupManagerSettings() {
        return this.deleteInstancesInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<GetInstanceGroupManagerHttpRequest, InstanceGroupManager> getInstanceGroupManagerSettings() {
        return this.getInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<InsertInstanceGroupManagerHttpRequest, Operation> insertInstanceGroupManagerSettings() {
        return this.insertInstanceGroupManagerSettings;
    }

    public PagedCallSettings<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> listInstanceGroupManagersSettings() {
        return this.listInstanceGroupManagersSettings;
    }

    public UnaryCallSettings<ListManagedInstancesInstanceGroupManagersHttpRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesInstanceGroupManagersSettings() {
        return this.listManagedInstancesInstanceGroupManagersSettings;
    }

    public UnaryCallSettings<PatchInstanceGroupManagerHttpRequest, Operation> patchInstanceGroupManagerSettings() {
        return this.patchInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<RecreateInstancesInstanceGroupManagerHttpRequest, Operation> recreateInstancesInstanceGroupManagerSettings() {
        return this.recreateInstancesInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<ResizeInstanceGroupManagerHttpRequest, Operation> resizeInstanceGroupManagerSettings() {
        return this.resizeInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<SetInstanceTemplateInstanceGroupManagerHttpRequest, Operation> setInstanceTemplateInstanceGroupManagerSettings() {
        return this.setInstanceTemplateInstanceGroupManagerSettings;
    }

    public UnaryCallSettings<SetTargetPoolsInstanceGroupManagerHttpRequest, Operation> setTargetPoolsInstanceGroupManagerSettings() {
        return this.setTargetPoolsInstanceGroupManagerSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceGroupManagerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceGroupManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceGroupManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceGroupManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.abandonInstancesInstanceGroupManagerSettings = settingsBuilder.abandonInstancesInstanceGroupManagerSettings().build();
        this.aggregatedListInstanceGroupManagersSettings = settingsBuilder.aggregatedListInstanceGroupManagersSettings().build();
        this.deleteInstanceGroupManagerSettings = settingsBuilder.deleteInstanceGroupManagerSettings().build();
        this.deleteInstancesInstanceGroupManagerSettings = settingsBuilder.deleteInstancesInstanceGroupManagerSettings().build();
        this.getInstanceGroupManagerSettings = settingsBuilder.getInstanceGroupManagerSettings().build();
        this.insertInstanceGroupManagerSettings = settingsBuilder.insertInstanceGroupManagerSettings().build();
        this.listInstanceGroupManagersSettings = settingsBuilder.listInstanceGroupManagersSettings().build();
        this.listManagedInstancesInstanceGroupManagersSettings = settingsBuilder.listManagedInstancesInstanceGroupManagersSettings().build();
        this.patchInstanceGroupManagerSettings = settingsBuilder.patchInstanceGroupManagerSettings().build();
        this.recreateInstancesInstanceGroupManagerSettings = settingsBuilder.recreateInstancesInstanceGroupManagerSettings().build();
        this.resizeInstanceGroupManagerSettings = settingsBuilder.resizeInstanceGroupManagerSettings().build();
        this.setInstanceTemplateInstanceGroupManagerSettings = settingsBuilder.setInstanceTemplateInstanceGroupManagerSettings().build();
        this.setTargetPoolsInstanceGroupManagerSettings = settingsBuilder.setTargetPoolsInstanceGroupManagerSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceGroupManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AbandonInstancesInstanceGroupManagerHttpRequest, Operation> abandonInstancesInstanceGroupManagerSettings;
        private final PagedCallSettings.Builder<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> aggregatedListInstanceGroupManagersSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceGroupManagerHttpRequest, Operation> deleteInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<DeleteInstancesInstanceGroupManagerHttpRequest, Operation> deleteInstancesInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<GetInstanceGroupManagerHttpRequest, InstanceGroupManager> getInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<InsertInstanceGroupManagerHttpRequest, Operation> insertInstanceGroupManagerSettings;
        private final PagedCallSettings.Builder<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> listInstanceGroupManagersSettings;
        private final UnaryCallSettings.Builder<ListManagedInstancesInstanceGroupManagersHttpRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesInstanceGroupManagersSettings;
        private final UnaryCallSettings.Builder<PatchInstanceGroupManagerHttpRequest, Operation> patchInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<RecreateInstancesInstanceGroupManagerHttpRequest, Operation> recreateInstancesInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<ResizeInstanceGroupManagerHttpRequest, Operation> resizeInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerHttpRequest, Operation> setInstanceTemplateInstanceGroupManagerSettings;
        private final UnaryCallSettings.Builder<SetTargetPoolsInstanceGroupManagerHttpRequest, Operation> setTargetPoolsInstanceGroupManagerSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.abandonInstancesInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.aggregatedListInstanceGroupManagersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_FACT);
            this.deleteInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstancesInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstanceGroupManagersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCE_GROUP_MANAGERS_PAGE_STR_FACT);
            this.listManagedInstancesInstanceGroupManagersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.recreateInstancesInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceTemplateInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTargetPoolsInstanceGroupManagerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesInstanceGroupManagerSettings, this.aggregatedListInstanceGroupManagersSettings, this.deleteInstanceGroupManagerSettings, this.deleteInstancesInstanceGroupManagerSettings, this.getInstanceGroupManagerSettings, this.insertInstanceGroupManagerSettings, this.listInstanceGroupManagersSettings, this.listManagedInstancesInstanceGroupManagersSettings, this.patchInstanceGroupManagerSettings, this.recreateInstancesInstanceGroupManagerSettings, this.resizeInstanceGroupManagerSettings, this.setInstanceTemplateInstanceGroupManagerSettings, (Object[])new UnaryCallSettings.Builder[]{this.setTargetPoolsInstanceGroupManagerSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceGroupManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceGroupManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceGroupManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(InstanceGroupManagerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.abandonInstancesInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.aggregatedListInstanceGroupManagersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInstancesInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstanceGroupManagersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listManagedInstancesInstanceGroupManagersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.recreateInstancesInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.resizeInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setInstanceTemplateInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setTargetPoolsInstanceGroupManagerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(InstanceGroupManagerStubSettings settings) {
            super((StubSettings)settings);
            this.abandonInstancesInstanceGroupManagerSettings = settings.abandonInstancesInstanceGroupManagerSettings.toBuilder();
            this.aggregatedListInstanceGroupManagersSettings = settings.aggregatedListInstanceGroupManagersSettings.toBuilder();
            this.deleteInstanceGroupManagerSettings = settings.deleteInstanceGroupManagerSettings.toBuilder();
            this.deleteInstancesInstanceGroupManagerSettings = settings.deleteInstancesInstanceGroupManagerSettings.toBuilder();
            this.getInstanceGroupManagerSettings = settings.getInstanceGroupManagerSettings.toBuilder();
            this.insertInstanceGroupManagerSettings = settings.insertInstanceGroupManagerSettings.toBuilder();
            this.listInstanceGroupManagersSettings = settings.listInstanceGroupManagersSettings.toBuilder();
            this.listManagedInstancesInstanceGroupManagersSettings = settings.listManagedInstancesInstanceGroupManagersSettings.toBuilder();
            this.patchInstanceGroupManagerSettings = settings.patchInstanceGroupManagerSettings.toBuilder();
            this.recreateInstancesInstanceGroupManagerSettings = settings.recreateInstancesInstanceGroupManagerSettings.toBuilder();
            this.resizeInstanceGroupManagerSettings = settings.resizeInstanceGroupManagerSettings.toBuilder();
            this.setInstanceTemplateInstanceGroupManagerSettings = settings.setInstanceTemplateInstanceGroupManagerSettings.toBuilder();
            this.setTargetPoolsInstanceGroupManagerSettings = settings.setTargetPoolsInstanceGroupManagerSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesInstanceGroupManagerSettings, this.aggregatedListInstanceGroupManagersSettings, this.deleteInstanceGroupManagerSettings, this.deleteInstancesInstanceGroupManagerSettings, this.getInstanceGroupManagerSettings, this.insertInstanceGroupManagerSettings, this.listInstanceGroupManagersSettings, this.listManagedInstancesInstanceGroupManagersSettings, this.patchInstanceGroupManagerSettings, this.recreateInstancesInstanceGroupManagerSettings, this.resizeInstanceGroupManagerSettings, this.setInstanceTemplateInstanceGroupManagerSettings, (Object[])new UnaryCallSettings.Builder[]{this.setTargetPoolsInstanceGroupManagerSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AbandonInstancesInstanceGroupManagerHttpRequest, Operation> abandonInstancesInstanceGroupManagerSettings() {
            return this.abandonInstancesInstanceGroupManagerSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstanceGroupManagersHttpRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagerClient.AggregatedListInstanceGroupManagersPagedResponse> aggregatedListInstanceGroupManagersSettings() {
            return this.aggregatedListInstanceGroupManagersSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceGroupManagerHttpRequest, Operation> deleteInstanceGroupManagerSettings() {
            return this.deleteInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstancesInstanceGroupManagerHttpRequest, Operation> deleteInstancesInstanceGroupManagerSettings() {
            return this.deleteInstancesInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceGroupManagerHttpRequest, InstanceGroupManager> getInstanceGroupManagerSettings() {
            return this.getInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceGroupManagerHttpRequest, Operation> insertInstanceGroupManagerSettings() {
            return this.insertInstanceGroupManagerSettings;
        }

        public PagedCallSettings.Builder<ListInstanceGroupManagersHttpRequest, InstanceGroupManagerList, InstanceGroupManagerClient.ListInstanceGroupManagersPagedResponse> listInstanceGroupManagersSettings() {
            return this.listInstanceGroupManagersSettings;
        }

        public UnaryCallSettings.Builder<ListManagedInstancesInstanceGroupManagersHttpRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesInstanceGroupManagersSettings() {
            return this.listManagedInstancesInstanceGroupManagersSettings;
        }

        public UnaryCallSettings.Builder<PatchInstanceGroupManagerHttpRequest, Operation> patchInstanceGroupManagerSettings() {
            return this.patchInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<RecreateInstancesInstanceGroupManagerHttpRequest, Operation> recreateInstancesInstanceGroupManagerSettings() {
            return this.recreateInstancesInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<ResizeInstanceGroupManagerHttpRequest, Operation> resizeInstanceGroupManagerSettings() {
            return this.resizeInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerHttpRequest, Operation> setInstanceTemplateInstanceGroupManagerSettings() {
            return this.setInstanceTemplateInstanceGroupManagerSettings;
        }

        public UnaryCallSettings.Builder<SetTargetPoolsInstanceGroupManagerHttpRequest, Operation> setTargetPoolsInstanceGroupManagerSettings() {
            return this.setTargetPoolsInstanceGroupManagerSettings;
        }

        public InstanceGroupManagerStubSettings build() throws IOException {
            return new InstanceGroupManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

