/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionOperationHttpRequest;
import com.google.cloud.compute.v1.GetRegionOperationHttpRequest;
import com.google.cloud.compute.v1.ListRegionOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.RegionOperationClient;
import com.google.cloud.compute.v1.stub.HttpJsonRegionOperationStub;
import com.google.cloud.compute.v1.stub.RegionOperationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RegionOperationStubSettings
extends StubSettings<RegionOperationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<DeleteRegionOperationHttpRequest, Void> deleteRegionOperationSettings;
    private final UnaryCallSettings<GetRegionOperationHttpRequest, Operation> getRegionOperationSettings;
    private final PagedCallSettings<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse> listRegionOperationsSettings;
    private static final PagedListDescriptor<ListRegionOperationsHttpRequest, OperationList, Operation> LIST_REGION_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListRegionOperationsHttpRequest, OperationList, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionOperationsHttpRequest injectToken(ListRegionOperationsHttpRequest payload, String token) {
            return ListRegionOperationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListRegionOperationsHttpRequest injectPageSize(ListRegionOperationsHttpRequest payload, int pageSize) {
            return ListRegionOperationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionOperationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(OperationList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse> LIST_REGION_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse>(){

        public ApiFuture<RegionOperationClient.ListRegionOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionOperationsHttpRequest, OperationList> callable, ListRegionOperationsHttpRequest request, ApiCallContext context, ApiFuture<OperationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REGION_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionOperationClient.ListRegionOperationsPagedResponse.createAsync((PageContext<ListRegionOperationsHttpRequest, OperationList, Operation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionOperationHttpRequest, Void> deleteRegionOperationSettings() {
        return this.deleteRegionOperationSettings;
    }

    public UnaryCallSettings<GetRegionOperationHttpRequest, Operation> getRegionOperationSettings() {
        return this.getRegionOperationSettings;
    }

    public PagedCallSettings<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse> listRegionOperationsSettings() {
        return this.listRegionOperationsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionOperationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionOperationStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://compute.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionOperationStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionOperationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionOperationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteRegionOperationSettings = settingsBuilder.deleteRegionOperationSettings().build();
        this.getRegionOperationSettings = settingsBuilder.getRegionOperationSettings().build();
        this.listRegionOperationsSettings = settingsBuilder.listRegionOperationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionOperationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionOperationHttpRequest, Void> deleteRegionOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionOperationHttpRequest, Operation> getRegionOperationSettings;
        private final PagedCallSettings.Builder<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse> listRegionOperationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteRegionOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRegionOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRegionOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REGION_OPERATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionOperationSettings, this.getRegionOperationSettings, this.listRegionOperationsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionOperationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionOperationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionOperationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionOperationStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteRegionOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getRegionOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRegionOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(RegionOperationStubSettings settings) {
            super((StubSettings)settings);
            this.deleteRegionOperationSettings = settings.deleteRegionOperationSettings.toBuilder();
            this.getRegionOperationSettings = settings.getRegionOperationSettings.toBuilder();
            this.listRegionOperationsSettings = settings.listRegionOperationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteRegionOperationSettings, this.getRegionOperationSettings, this.listRegionOperationsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionOperationHttpRequest, Void> deleteRegionOperationSettings() {
            return this.deleteRegionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionOperationHttpRequest, Operation> getRegionOperationSettings() {
            return this.getRegionOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionOperationsHttpRequest, OperationList, RegionOperationClient.ListRegionOperationsPagedResponse> listRegionOperationsSettings() {
            return this.listRegionOperationsSettings;
        }

        public RegionOperationStubSettings build() throws IOException {
            return new RegionOperationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

