/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.DeleteGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GetGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GlobalAddressClient;
import com.google.cloud.compute.v1.InsertGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.ListGlobalAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalAddressName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.GlobalAddressStub;
import com.google.cloud.compute.v1.stub.GlobalAddressStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalAddressCallableFactory;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonGlobalAddressStub
extends GlobalAddressStub {
    @InternalApi
    public static final ApiMethodDescriptor<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalAddresses.delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/addresses/{address}")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectGlobalAddressName.newFactory()).setResourceNameField("address").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetGlobalAddressHttpRequest, Address> getGlobalAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalAddresses.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/addresses/{address}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectGlobalAddressName.newFactory()).setResourceNameField("address").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Address.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalAddresses.insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/addresses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"requestId"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListGlobalAddressesHttpRequest, AddressList> listGlobalAddressesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.globalAddresses.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/global/addresses")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)AddressList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressCallable;
    private final UnaryCallable<GetGlobalAddressHttpRequest, Address> getGlobalAddressCallable;
    private final UnaryCallable<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressCallable;
    private final UnaryCallable<ListGlobalAddressesHttpRequest, AddressList> listGlobalAddressesCallable;
    private final UnaryCallable<ListGlobalAddressesHttpRequest, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGlobalAddressStub create(GlobalAddressStubSettings settings) throws IOException {
        return new HttpJsonGlobalAddressStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGlobalAddressStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGlobalAddressStub(GlobalAddressStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonGlobalAddressStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGlobalAddressStub(GlobalAddressStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGlobalAddressStub(GlobalAddressStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGlobalAddressCallableFactory());
    }

    protected HttpJsonGlobalAddressStub(GlobalAddressStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings deleteGlobalAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGlobalAddressMethodDescriptor).build();
        HttpJsonCallSettings getGlobalAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGlobalAddressMethodDescriptor).build();
        HttpJsonCallSettings insertGlobalAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertGlobalAddressMethodDescriptor).build();
        HttpJsonCallSettings listGlobalAddressesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGlobalAddressesMethodDescriptor).build();
        this.deleteGlobalAddressCallable = callableFactory.createUnaryCallable(deleteGlobalAddressTransportSettings, settings.deleteGlobalAddressSettings(), clientContext);
        this.getGlobalAddressCallable = callableFactory.createUnaryCallable(getGlobalAddressTransportSettings, settings.getGlobalAddressSettings(), clientContext);
        this.insertGlobalAddressCallable = callableFactory.createUnaryCallable(insertGlobalAddressTransportSettings, settings.insertGlobalAddressSettings(), clientContext);
        this.listGlobalAddressesCallable = callableFactory.createUnaryCallable(listGlobalAddressesTransportSettings, settings.listGlobalAddressesSettings(), clientContext);
        this.listGlobalAddressesPagedCallable = callableFactory.createPagedCallable(listGlobalAddressesTransportSettings, settings.listGlobalAddressesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressCallable() {
        return this.deleteGlobalAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<GetGlobalAddressHttpRequest, Address> getGlobalAddressCallable() {
        return this.getGlobalAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressCallable() {
        return this.insertGlobalAddressCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListGlobalAddressesHttpRequest, GlobalAddressClient.ListGlobalAddressesPagedResponse> listGlobalAddressesPagedCallable() {
        return this.listGlobalAddressesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListGlobalAddressesHttpRequest, AddressList> listGlobalAddressesCallable() {
        return this.listGlobalAddressesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

