/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalSnapshotName
implements ResourceName {
    private final String project;
    private final String snapshot;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/snapshots/{snapshot}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalSnapshotName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.snapshot = (String)Preconditions.checkNotNull((Object)builder.getSnapshot());
    }

    public static ProjectGlobalSnapshotName of(String project, String snapshot) {
        return ProjectGlobalSnapshotName.newBuilder().setProject(project).setSnapshot(snapshot).build();
    }

    public static String format(String project, String snapshot) {
        return ProjectGlobalSnapshotName.of(project, snapshot).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalSnapshotName projectGlobalSnapshotName = this;
            synchronized (projectGlobalSnapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"snapshot", (Object)this.snapshot);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalSnapshotName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalSnapshotName>(){

            public ProjectGlobalSnapshotName parse(String formattedString) {
                return ProjectGlobalSnapshotName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalSnapshotName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalSnapshotName.parse: formattedString not in valid format");
        return ProjectGlobalSnapshotName.of((String)matchMap.get("project"), (String)matchMap.get("snapshot"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "snapshot", this.snapshot});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalSnapshotName) {
            ProjectGlobalSnapshotName that = (ProjectGlobalSnapshotName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.snapshot, that.getSnapshot());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.snapshot);
    }

    public static class Builder {
        private String project;
        private String snapshot;

        public String getProject() {
            return this.project;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalSnapshotName projectGlobalSnapshotName) {
            this.project = projectGlobalSnapshotName.project;
            this.snapshot = projectGlobalSnapshotName.snapshot;
        }

        public ProjectGlobalSnapshotName build() {
            return new ProjectGlobalSnapshotName(this);
        }
    }
}

