/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectGlobalRouteName
implements ResourceName {
    private final String project;
    private final String route;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/global/routes/{route}");
    public static final String SERVICE_ADDRESS = "https://compute.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectGlobalRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.route = (String)Preconditions.checkNotNull((Object)builder.getRoute());
    }

    public static ProjectGlobalRouteName of(String project, String route) {
        return ProjectGlobalRouteName.newBuilder().setProject(project).setRoute(route).build();
    }

    public static String format(String project, String route) {
        return ProjectGlobalRouteName.of(project, route).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRoute() {
        return this.route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectGlobalRouteName projectGlobalRouteName = this;
            synchronized (projectGlobalRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"route", (Object)this.route);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectGlobalRouteName> newFactory() {
        return new ResourceNameFactory<ProjectGlobalRouteName>(){

            public ProjectGlobalRouteName parse(String formattedString) {
                return ProjectGlobalRouteName.parse(formattedString);
            }
        };
    }

    public static ProjectGlobalRouteName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectGlobalRouteName.parse: formattedString not in valid format");
        return ProjectGlobalRouteName.of((String)matchMap.get("project"), (String)matchMap.get("route"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "route", this.route});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectGlobalRouteName) {
            ProjectGlobalRouteName that = (ProjectGlobalRouteName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.route, that.getRoute());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.route);
    }

    public static class Builder {
        private String project;
        private String route;

        public String getProject() {
            return this.project;
        }

        public String getRoute() {
            return this.route;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectGlobalRouteName projectGlobalRouteName) {
            this.project = projectGlobalRouteName.project;
            this.route = projectGlobalRouteName.route;
        }

        public ProjectGlobalRouteName build() {
            return new ProjectGlobalRouteName(this);
        }
    }
}

