/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.DeleteGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GetGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.GlobalAddressSettings;
import com.google.cloud.compute.v1.InsertGlobalAddressHttpRequest;
import com.google.cloud.compute.v1.ListGlobalAddressesHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.ProjectGlobalAddressName;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.stub.GlobalAddressStub;
import com.google.cloud.compute.v1.stub.GlobalAddressStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalAddressClient
implements BackgroundResource {
    private final GlobalAddressSettings settings;
    private final GlobalAddressStub stub;

    public static final GlobalAddressClient create() throws IOException {
        return GlobalAddressClient.create(GlobalAddressSettings.newBuilder().build());
    }

    public static final GlobalAddressClient create(GlobalAddressSettings settings) throws IOException {
        return new GlobalAddressClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalAddressClient create(GlobalAddressStub stub) {
        return new GlobalAddressClient(stub);
    }

    protected GlobalAddressClient(GlobalAddressSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalAddressStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalAddressClient(GlobalAddressStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalAddressSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalAddressStub getStub() {
        return this.stub;
    }

    @BetaApi
    public final Operation deleteGlobalAddress(ProjectGlobalAddressName address) {
        DeleteGlobalAddressHttpRequest request = DeleteGlobalAddressHttpRequest.newBuilder().setAddress(address == null ? null : address.toString()).build();
        return this.deleteGlobalAddress(request);
    }

    @BetaApi
    public final Operation deleteGlobalAddress(String address) {
        DeleteGlobalAddressHttpRequest request = DeleteGlobalAddressHttpRequest.newBuilder().setAddress(address).build();
        return this.deleteGlobalAddress(request);
    }

    @BetaApi
    public final Operation deleteGlobalAddress(DeleteGlobalAddressHttpRequest request) {
        return (Operation)this.deleteGlobalAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<DeleteGlobalAddressHttpRequest, Operation> deleteGlobalAddressCallable() {
        return this.stub.deleteGlobalAddressCallable();
    }

    @BetaApi
    public final Address getGlobalAddress(ProjectGlobalAddressName address) {
        GetGlobalAddressHttpRequest request = GetGlobalAddressHttpRequest.newBuilder().setAddress(address == null ? null : address.toString()).build();
        return this.getGlobalAddress(request);
    }

    @BetaApi
    public final Address getGlobalAddress(String address) {
        GetGlobalAddressHttpRequest request = GetGlobalAddressHttpRequest.newBuilder().setAddress(address).build();
        return this.getGlobalAddress(request);
    }

    @BetaApi
    public final Address getGlobalAddress(GetGlobalAddressHttpRequest request) {
        return (Address)this.getGlobalAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<GetGlobalAddressHttpRequest, Address> getGlobalAddressCallable() {
        return this.stub.getGlobalAddressCallable();
    }

    @BetaApi
    public final Operation insertGlobalAddress(ProjectName project, Address addressResource) {
        InsertGlobalAddressHttpRequest request = InsertGlobalAddressHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).setAddressResource(addressResource).build();
        return this.insertGlobalAddress(request);
    }

    @BetaApi
    public final Operation insertGlobalAddress(String project, Address addressResource) {
        InsertGlobalAddressHttpRequest request = InsertGlobalAddressHttpRequest.newBuilder().setProject(project).setAddressResource(addressResource).build();
        return this.insertGlobalAddress(request);
    }

    @BetaApi
    public final Operation insertGlobalAddress(InsertGlobalAddressHttpRequest request) {
        return (Operation)this.insertGlobalAddressCallable().call((Object)request);
    }

    @BetaApi
    public final UnaryCallable<InsertGlobalAddressHttpRequest, Operation> insertGlobalAddressCallable() {
        return this.stub.insertGlobalAddressCallable();
    }

    @BetaApi
    public final ListGlobalAddressesPagedResponse listGlobalAddresses(ProjectName project) {
        ListGlobalAddressesHttpRequest request = ListGlobalAddressesHttpRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listGlobalAddresses(request);
    }

    @BetaApi
    public final ListGlobalAddressesPagedResponse listGlobalAddresses(String project) {
        ListGlobalAddressesHttpRequest request = ListGlobalAddressesHttpRequest.newBuilder().setProject(project).build();
        return this.listGlobalAddresses(request);
    }

    @BetaApi
    public final ListGlobalAddressesPagedResponse listGlobalAddresses(ListGlobalAddressesHttpRequest request) {
        return (ListGlobalAddressesPagedResponse)((Object)this.listGlobalAddressesPagedCallable().call((Object)request));
    }

    @BetaApi
    public final UnaryCallable<ListGlobalAddressesHttpRequest, ListGlobalAddressesPagedResponse> listGlobalAddressesPagedCallable() {
        return this.stub.listGlobalAddressesPagedCallable();
    }

    @BetaApi
    public final UnaryCallable<ListGlobalAddressesHttpRequest, AddressList> listGlobalAddressesCallable() {
        return this.stub.listGlobalAddressesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGlobalAddressesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalAddressesHttpRequest, AddressList, Address, ListGlobalAddressesPage, ListGlobalAddressesFixedSizeCollection> {
        private ListGlobalAddressesFixedSizeCollection(List<ListGlobalAddressesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlobalAddressesFixedSizeCollection createEmptyCollection() {
            return new ListGlobalAddressesFixedSizeCollection(null, 0);
        }

        protected ListGlobalAddressesFixedSizeCollection createCollection(List<ListGlobalAddressesPage> pages, int collectionSize) {
            return new ListGlobalAddressesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlobalAddressesPage
    extends AbstractPage<ListGlobalAddressesHttpRequest, AddressList, Address, ListGlobalAddressesPage> {
        private ListGlobalAddressesPage(PageContext<ListGlobalAddressesHttpRequest, AddressList, Address> context, AddressList response) {
            super(context, (Object)response);
        }

        private static ListGlobalAddressesPage createEmptyPage() {
            return new ListGlobalAddressesPage(null, null);
        }

        protected ListGlobalAddressesPage createPage(PageContext<ListGlobalAddressesHttpRequest, AddressList, Address> context, AddressList response) {
            return new ListGlobalAddressesPage(context, response);
        }

        public ApiFuture<ListGlobalAddressesPage> createPageAsync(PageContext<ListGlobalAddressesHttpRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlobalAddressesPagedResponse
    extends AbstractPagedListResponse<ListGlobalAddressesHttpRequest, AddressList, Address, ListGlobalAddressesPage, ListGlobalAddressesFixedSizeCollection> {
        public static ApiFuture<ListGlobalAddressesPagedResponse> createAsync(PageContext<ListGlobalAddressesHttpRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            ApiFuture<ListGlobalAddressesPage> futurePage = ListGlobalAddressesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGlobalAddressesPage, ListGlobalAddressesPagedResponse>(){

                public ListGlobalAddressesPagedResponse apply(ListGlobalAddressesPage input) {
                    return new ListGlobalAddressesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListGlobalAddressesPagedResponse(ListGlobalAddressesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlobalAddressesFixedSizeCollection.createEmptyCollection());
        }
    }
}

