/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.deprecated;

import com.google.cloud.compute.deprecated.ForwardingRuleId;
import com.google.cloud.compute.deprecated.RegionId;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegionForwardingRuleId
extends ForwardingRuleId {
    static final Function<String, RegionForwardingRuleId> FROM_URL_FUNCTION = new Function<String, RegionForwardingRuleId>(){

        public RegionForwardingRuleId apply(String pb) {
            return RegionForwardingRuleId.fromUrl(pb);
        }
    };
    static final Function<RegionForwardingRuleId, String> TO_URL_FUNCTION = new Function<RegionForwardingRuleId, String>(){

        public String apply(RegionForwardingRuleId forwardingRuleId) {
            return forwardingRuleId.getSelfLink();
        }
    };
    private static final String REGEX = ".*?projects/([^/]+)/regions/([^/]+)/forwardingRules/([^/]+)";
    private static final Pattern PATTERN = Pattern.compile(".*?projects/([^/]+)/regions/([^/]+)/forwardingRules/([^/]+)");
    private static final long serialVersionUID = 7885327931402904667L;
    private final String region;

    private RegionForwardingRuleId(String project, String region, String rule) {
        super(project, rule);
        this.region = (String)Preconditions.checkNotNull((Object)region);
    }

    @Override
    public ForwardingRuleId.Type getType() {
        return ForwardingRuleId.Type.REGION;
    }

    public String getRegion() {
        return this.region;
    }

    public RegionId getRegionId() {
        return RegionId.of(this.getProject(), this.region);
    }

    @Override
    public String getSelfLink() {
        return super.getSelfLink() + "/regions/" + this.region + "/forwardingRules/" + this.getRule();
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.region);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegionForwardingRuleId)) {
            return false;
        }
        RegionForwardingRuleId other = (RegionForwardingRuleId)obj;
        return this.baseEquals(other) && Objects.equals(this.region, other.region);
    }

    @Override
    RegionForwardingRuleId setProjectId(String projectId) {
        if (this.getProject() != null) {
            return this;
        }
        return RegionForwardingRuleId.of(projectId, this.region, this.getRule());
    }

    public static RegionForwardingRuleId of(RegionId regionId, String rule) {
        return new RegionForwardingRuleId(regionId.getProject(), regionId.getRegion(), rule);
    }

    public static RegionForwardingRuleId of(String region, String rule) {
        return new RegionForwardingRuleId(null, region, rule);
    }

    public static RegionForwardingRuleId of(String project, String region, String rule) {
        return new RegionForwardingRuleId(project, region, rule);
    }

    static boolean matchesUrl(String url) {
        return PATTERN.matcher(url).matches();
    }

    static RegionForwardingRuleId fromUrl(String url) {
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(url + " is not a valid region forwarding rule URL");
        }
        return RegionForwardingRuleId.of(matcher.group(1), matcher.group(2), matcher.group(3));
    }
}

