/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.httpjson.ApiMessage;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@BetaApi
public final class ReservationAffinity
implements ApiMessage {
    private final String consumeReservationType;
    private final String key;
    private final List<String> values;
    private static final ReservationAffinity DEFAULT_INSTANCE = new ReservationAffinity();

    private ReservationAffinity() {
        this.consumeReservationType = null;
        this.key = null;
        this.values = null;
    }

    private ReservationAffinity(String consumeReservationType, String key, List<String> values) {
        this.consumeReservationType = consumeReservationType;
        this.key = key;
        this.values = values;
    }

    public Object getFieldValue(String fieldName) {
        if ("consumeReservationType".equals(fieldName)) {
            return this.consumeReservationType;
        }
        if ("key".equals(fieldName)) {
            return this.key;
        }
        if ("values".equals(fieldName)) {
            return this.values;
        }
        return null;
    }

    @Nullable
    public ApiMessage getApiMessageRequestBody() {
        return null;
    }

    @Nullable
    public List<String> getFieldMask() {
        return null;
    }

    public String getConsumeReservationType() {
        return this.consumeReservationType;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getValuesList() {
        return this.values;
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ReservationAffinity prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    public static ReservationAffinity getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public String toString() {
        return "ReservationAffinity{consumeReservationType=" + this.consumeReservationType + ", key=" + this.key + ", values=" + this.values + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReservationAffinity) {
            ReservationAffinity that = (ReservationAffinity)o;
            return Objects.equals(this.consumeReservationType, that.getConsumeReservationType()) && Objects.equals(this.key, that.getKey()) && Objects.equals(this.values, that.getValuesList());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.consumeReservationType, this.key, this.values);
    }

    public static class Builder {
        private String consumeReservationType;
        private String key;
        private List<String> values;

        Builder() {
        }

        public Builder mergeFrom(ReservationAffinity other) {
            if (other == ReservationAffinity.getDefaultInstance()) {
                return this;
            }
            if (other.getConsumeReservationType() != null) {
                this.consumeReservationType = other.consumeReservationType;
            }
            if (other.getKey() != null) {
                this.key = other.key;
            }
            if (other.getValuesList() != null) {
                this.values = other.values;
            }
            return this;
        }

        Builder(ReservationAffinity source) {
            this.consumeReservationType = source.consumeReservationType;
            this.key = source.key;
            this.values = source.values;
        }

        public String getConsumeReservationType() {
            return this.consumeReservationType;
        }

        public Builder setConsumeReservationType(String consumeReservationType) {
            this.consumeReservationType = consumeReservationType;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public List<String> getValuesList() {
            return this.values;
        }

        public Builder addAllValues(List<String> values) {
            if (this.values == null) {
                this.values = new LinkedList<String>();
            }
            this.values.addAll(values);
            return this;
        }

        public Builder addValues(String values) {
            if (this.values == null) {
                this.values = new LinkedList<String>();
            }
            this.values.add(values);
            return this;
        }

        public ReservationAffinity build() {
            return new ReservationAffinity(this.consumeReservationType, this.key, this.values);
        }

        public Builder clone() {
            Builder newBuilder = new Builder();
            newBuilder.setConsumeReservationType(this.consumeReservationType);
            newBuilder.setKey(this.key);
            newBuilder.addAllValues(this.values);
            return newBuilder;
        }
    }
}

