/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneReservationName
implements ResourceName {
    private final String project;
    private final String reservation;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/reservations/{reservation}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneReservationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.reservation = (String)Preconditions.checkNotNull((Object)builder.getReservation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneReservationName of(String project, String reservation, String zone) {
        return ProjectZoneReservationName.newBuilder().setProject(project).setReservation(reservation).setZone(zone).build();
    }

    public static String format(String project, String reservation, String zone) {
        return ProjectZoneReservationName.of(project, reservation, zone).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getReservation() {
        return this.reservation;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneReservationName projectZoneReservationName = this;
            synchronized (projectZoneReservationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"reservation", (Object)this.reservation);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneReservationName> newFactory() {
        return new ResourceNameFactory<ProjectZoneReservationName>(){

            public ProjectZoneReservationName parse(String formattedString) {
                return ProjectZoneReservationName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneReservationName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneReservationName.parse: formattedString not in valid format");
        return ProjectZoneReservationName.of((String)matchMap.get("project"), (String)matchMap.get("reservation"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "reservation", this.reservation, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneReservationName) {
            ProjectZoneReservationName that = (ProjectZoneReservationName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.reservation, that.getReservation()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.reservation, this.zone);
    }

    public static class Builder {
        private String project;
        private String reservation;
        private String zone;

        public String getProject() {
            return this.project;
        }

        public String getReservation() {
            return this.reservation;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneReservationName projectZoneReservationName) {
            this.project = projectZoneReservationName.project;
            this.reservation = projectZoneReservationName.reservation;
            this.zone = projectZoneReservationName.zone;
        }

        public ProjectZoneReservationName build() {
            return new ProjectZoneReservationName(this);
        }
    }
}

