/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectRegionResourcePolicyName
implements ResourceName {
    private final String project;
    private final String region;
    private final String resourcePolicy;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/regions/{region}/resourcePolicies/{resourcePolicy}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRegionResourcePolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.region = (String)Preconditions.checkNotNull((Object)builder.getRegion());
        this.resourcePolicy = (String)Preconditions.checkNotNull((Object)builder.getResourcePolicy());
    }

    public static ProjectRegionResourcePolicyName of(String project, String region, String resourcePolicy) {
        return ProjectRegionResourcePolicyName.newBuilder().setProject(project).setRegion(region).setResourcePolicy(resourcePolicy).build();
    }

    public static String format(String project, String region, String resourcePolicy) {
        return ProjectRegionResourcePolicyName.of(project, region, resourcePolicy).toString();
    }

    public String getProject() {
        return this.project;
    }

    public String getRegion() {
        return this.region;
    }

    public String getResourcePolicy() {
        return this.resourcePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRegionResourcePolicyName projectRegionResourcePolicyName = this;
            synchronized (projectRegionResourcePolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"region", (Object)this.region);
                    fieldMapBuilder.put((Object)"resourcePolicy", (Object)this.resourcePolicy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectRegionResourcePolicyName> newFactory() {
        return new ResourceNameFactory<ProjectRegionResourcePolicyName>(){

            public ProjectRegionResourcePolicyName parse(String formattedString) {
                return ProjectRegionResourcePolicyName.parse(formattedString);
            }
        };
    }

    public static ProjectRegionResourcePolicyName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectRegionResourcePolicyName.parse: formattedString not in valid format");
        return ProjectRegionResourcePolicyName.of((String)matchMap.get("project"), (String)matchMap.get("region"), (String)matchMap.get("resourcePolicy"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "region", this.region, "resourcePolicy", this.resourcePolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRegionResourcePolicyName) {
            ProjectRegionResourcePolicyName that = (ProjectRegionResourcePolicyName)o;
            return Objects.equals(this.project, that.getProject()) && Objects.equals(this.region, that.getRegion()) && Objects.equals(this.resourcePolicy, that.getResourcePolicy());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.region, this.resourcePolicy);
    }

    public static class Builder {
        private String project;
        private String region;
        private String resourcePolicy;

        public String getProject() {
            return this.project;
        }

        public String getRegion() {
            return this.region;
        }

        public String getResourcePolicy() {
            return this.resourcePolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectRegionResourcePolicyName projectRegionResourcePolicyName) {
            this.project = projectRegionResourcePolicyName.project;
            this.region = projectRegionResourcePolicyName.region;
            this.resourcePolicy = projectRegionResourcePolicyName.resourcePolicy;
        }

        public ProjectRegionResourcePolicyName build() {
            return new ProjectRegionResourcePolicyName(this);
        }
    }
}

