/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

@BetaApi
public final class ProjectZoneInstanceGroupName
implements ResourceName {
    private final String instanceGroup;
    private final String project;
    private final String zone;
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"{project}/zones/{zone}/instanceGroups/{instanceGroup}");
    public static final String SERVICE_ADDRESS = "https://www.googleapis.com/compute/v1/projects/";
    private volatile Map<String, String> fieldValuesMap;

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectZoneInstanceGroupName(Builder builder) {
        this.instanceGroup = (String)Preconditions.checkNotNull((Object)builder.getInstanceGroup());
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public static ProjectZoneInstanceGroupName of(String instanceGroup, String project, String zone) {
        return ProjectZoneInstanceGroupName.newBuilder().setInstanceGroup(instanceGroup).setProject(project).setZone(zone).build();
    }

    public static String format(String instanceGroup, String project, String zone) {
        return ProjectZoneInstanceGroupName.of(instanceGroup, project, zone).toString();
    }

    public String getInstanceGroup() {
        return this.instanceGroup;
    }

    public String getProject() {
        return this.project;
    }

    public String getZone() {
        return this.zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectZoneInstanceGroupName projectZoneInstanceGroupName = this;
            synchronized (projectZoneInstanceGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"instanceGroup", (Object)this.instanceGroup);
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public static ResourceNameFactory<ProjectZoneInstanceGroupName> newFactory() {
        return new ResourceNameFactory<ProjectZoneInstanceGroupName>(){

            public ProjectZoneInstanceGroupName parse(String formattedString) {
                return ProjectZoneInstanceGroupName.parse(formattedString);
            }
        };
    }

    public static ProjectZoneInstanceGroupName parse(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(resourcePath, "ProjectZoneInstanceGroupName.parse: formattedString not in valid format");
        return ProjectZoneInstanceGroupName.of((String)matchMap.get("instanceGroup"), (String)matchMap.get("project"), (String)matchMap.get("zone"));
    }

    public static boolean isParsableFrom(String formattedString) {
        String resourcePath = formattedString;
        if (formattedString.startsWith(SERVICE_ADDRESS)) {
            resourcePath = formattedString.substring(SERVICE_ADDRESS.length());
        }
        return PATH_TEMPLATE.matches(resourcePath);
    }

    public String toString() {
        return SERVICE_ADDRESS + PATH_TEMPLATE.instantiate(new String[]{"instanceGroup", this.instanceGroup, "project", this.project, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectZoneInstanceGroupName) {
            ProjectZoneInstanceGroupName that = (ProjectZoneInstanceGroupName)o;
            return Objects.equals(this.instanceGroup, that.getInstanceGroup()) && Objects.equals(this.project, that.getProject()) && Objects.equals(this.zone, that.getZone());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.instanceGroup, this.project, this.zone);
    }

    public static class Builder {
        private String instanceGroup;
        private String project;
        private String zone;

        public String getInstanceGroup() {
            return this.instanceGroup;
        }

        public String getProject() {
            return this.project;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setInstanceGroup(String instanceGroup) {
            this.instanceGroup = instanceGroup;
            return this;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder() {
        }

        public Builder(ProjectZoneInstanceGroupName projectZoneInstanceGroupName) {
            this.instanceGroup = projectZoneInstanceGroupName.instanceGroup;
            this.project = projectZoneInstanceGroupName.project;
            this.zone = projectZoneInstanceGroupName.zone;
        }

        public ProjectZoneInstanceGroupName build() {
            return new ProjectZoneInstanceGroupName(this);
        }
    }
}

