/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2beta.Attachment;
import com.google.cloud.support.v2beta.CaseAttachmentServiceClient;
import com.google.cloud.support.v2beta.GetAttachmentRequest;
import com.google.cloud.support.v2beta.ListAttachmentsRequest;
import com.google.cloud.support.v2beta.ListAttachmentsResponse;
import com.google.cloud.support.v2beta.stub.CaseAttachmentServiceStub;
import com.google.cloud.support.v2beta.stub.GrpcCaseAttachmentServiceStub;
import com.google.cloud.support.v2beta.stub.HttpJsonCaseAttachmentServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class CaseAttachmentServiceStubSettings
extends StubSettings<CaseAttachmentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings;
    private final UnaryCallSettings<GetAttachmentRequest, Attachment> getAttachmentSettings;
    private static final PagedListDescriptor<ListAttachmentsRequest, ListAttachmentsResponse, Attachment> LIST_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAttachmentsRequest, ListAttachmentsResponse, Attachment>(){

        public String emptyToken() {
            return "";
        }

        public ListAttachmentsRequest injectToken(ListAttachmentsRequest payload, String token) {
            return ListAttachmentsRequest.newBuilder((ListAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListAttachmentsRequest injectPageSize(ListAttachmentsRequest payload, int pageSize) {
            return ListAttachmentsRequest.newBuilder((ListAttachmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAttachmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAttachmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Attachment> extractResources(ListAttachmentsResponse payload) {
            return payload.getAttachmentsList();
        }
    };
    private static final PagedListResponseFactory<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> LIST_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse>(){

        public ApiFuture<CaseAttachmentServiceClient.ListAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAttachmentsRequest, ListAttachmentsResponse> callable, ListAttachmentsRequest request, ApiCallContext context, ApiFuture<ListAttachmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CaseAttachmentServiceClient.ListAttachmentsPagedResponse.createAsync((PageContext<ListAttachmentsRequest, ListAttachmentsResponse, Attachment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings() {
        return this.listAttachmentsSettings;
    }

    public UnaryCallSettings<GetAttachmentRequest, Attachment> getAttachmentSettings() {
        return this.getAttachmentSettings;
    }

    public CaseAttachmentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCaseAttachmentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCaseAttachmentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudsupport";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudsupport.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsupport.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CaseAttachmentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseAttachmentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CaseAttachmentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CaseAttachmentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CaseAttachmentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAttachmentsSettings = settingsBuilder.listAttachmentsSettings().build();
        this.getAttachmentSettings = settingsBuilder.getAttachmentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CaseAttachmentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings;
        private final UnaryCallSettings.Builder<GetAttachmentRequest, Attachment> getAttachmentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ATTACHMENTS_PAGE_STR_FACT);
            this.getAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAttachmentsSettings, this.getAttachmentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CaseAttachmentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAttachmentsSettings = settings.listAttachmentsSettings.toBuilder();
            this.getAttachmentSettings = settings.getAttachmentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAttachmentsSettings, this.getAttachmentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CaseAttachmentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CaseAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseAttachmentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CaseAttachmentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CaseAttachmentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CaseAttachmentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CaseAttachmentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAttachmentsRequest, ListAttachmentsResponse, CaseAttachmentServiceClient.ListAttachmentsPagedResponse> listAttachmentsSettings() {
            return this.listAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<GetAttachmentRequest, Attachment> getAttachmentSettings() {
            return this.getAttachmentSettings;
        }

        public CaseAttachmentServiceStubSettings build() throws IOException {
            return new CaseAttachmentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

