/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Comment;
import com.google.cloud.support.v2.CommentServiceClient;
import com.google.cloud.support.v2.CreateCommentRequest;
import com.google.cloud.support.v2.ListCommentsRequest;
import com.google.cloud.support.v2.ListCommentsResponse;
import com.google.cloud.support.v2.stub.CommentServiceStub;
import com.google.cloud.support.v2.stub.CommentServiceStubSettings;
import com.google.cloud.support.v2.stub.GrpcCommentServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCommentServiceStub
extends CommentServiceStub {
    private static final MethodDescriptor<ListCommentsRequest, ListCommentsResponse> listCommentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CommentService/ListComments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCommentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCommentsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateCommentRequest, Comment> createCommentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CommentService/CreateComment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCommentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Comment.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable;
    private final UnaryCallable<ListCommentsRequest, CommentServiceClient.ListCommentsPagedResponse> listCommentsPagedCallable;
    private final UnaryCallable<CreateCommentRequest, Comment> createCommentCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCommentServiceStub create(CommentServiceStubSettings settings) throws IOException {
        return new GrpcCommentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCommentServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCommentServiceStub(CommentServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCommentServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCommentServiceStub(CommentServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCommentServiceStub(CommentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCommentServiceCallableFactory());
    }

    protected GrpcCommentServiceStub(CommentServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listCommentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCommentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createCommentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCommentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.listCommentsCallable = callableFactory.createUnaryCallable(listCommentsTransportSettings, settings.listCommentsSettings(), clientContext);
        this.listCommentsPagedCallable = callableFactory.createPagedCallable(listCommentsTransportSettings, settings.listCommentsSettings(), clientContext);
        this.createCommentCallable = callableFactory.createUnaryCallable(createCommentTransportSettings, settings.createCommentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable() {
        return this.listCommentsCallable;
    }

    @Override
    public UnaryCallable<ListCommentsRequest, CommentServiceClient.ListCommentsPagedResponse> listCommentsPagedCallable() {
        return this.listCommentsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateCommentRequest, Comment> createCommentCallable() {
        return this.createCommentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

