/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Case;
import com.google.cloud.support.v2.CaseServiceClient;
import com.google.cloud.support.v2.CloseCaseRequest;
import com.google.cloud.support.v2.CreateCaseRequest;
import com.google.cloud.support.v2.EscalateCaseRequest;
import com.google.cloud.support.v2.GetCaseRequest;
import com.google.cloud.support.v2.ListCasesRequest;
import com.google.cloud.support.v2.ListCasesResponse;
import com.google.cloud.support.v2.SearchCaseClassificationsRequest;
import com.google.cloud.support.v2.SearchCaseClassificationsResponse;
import com.google.cloud.support.v2.SearchCasesRequest;
import com.google.cloud.support.v2.SearchCasesResponse;
import com.google.cloud.support.v2.UpdateCaseRequest;
import com.google.cloud.support.v2.stub.CaseServiceStub;
import com.google.cloud.support.v2.stub.CaseServiceStubSettings;
import com.google.cloud.support.v2.stub.GrpcCaseServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCaseServiceStub
extends CaseServiceStub {
    private static final MethodDescriptor<GetCaseRequest, Case> getCaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/GetCase").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Case.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListCasesRequest, ListCasesResponse> listCasesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/ListCases").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCasesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCasesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchCasesRequest, SearchCasesResponse> searchCasesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/SearchCases").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchCasesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchCasesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateCaseRequest, Case> createCaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/CreateCase").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Case.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateCaseRequest, Case> updateCaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/UpdateCase").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Case.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<EscalateCaseRequest, Case> escalateCaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/EscalateCase").setRequestMarshaller(ProtoUtils.marshaller((Message)EscalateCaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Case.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CloseCaseRequest, Case> closeCaseMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/CloseCase").setRequestMarshaller(ProtoUtils.marshaller((Message)CloseCaseRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Case.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.support.v2.CaseService/SearchCaseClassifications").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchCaseClassificationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchCaseClassificationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetCaseRequest, Case> getCaseCallable;
    private final UnaryCallable<ListCasesRequest, ListCasesResponse> listCasesCallable;
    private final UnaryCallable<ListCasesRequest, CaseServiceClient.ListCasesPagedResponse> listCasesPagedCallable;
    private final UnaryCallable<SearchCasesRequest, SearchCasesResponse> searchCasesCallable;
    private final UnaryCallable<SearchCasesRequest, CaseServiceClient.SearchCasesPagedResponse> searchCasesPagedCallable;
    private final UnaryCallable<CreateCaseRequest, Case> createCaseCallable;
    private final UnaryCallable<UpdateCaseRequest, Case> updateCaseCallable;
    private final UnaryCallable<EscalateCaseRequest, Case> escalateCaseCallable;
    private final UnaryCallable<CloseCaseRequest, Case> closeCaseCallable;
    private final UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsCallable;
    private final UnaryCallable<SearchCaseClassificationsRequest, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCaseServiceStub create(CaseServiceStubSettings settings) throws IOException {
        return new GrpcCaseServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCaseServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCaseServiceStub(CaseServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCaseServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCaseServiceStub(CaseServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCaseServiceStub(CaseServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCaseServiceCallableFactory());
    }

    protected GrpcCaseServiceStub(CaseServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listCasesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCasesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings searchCasesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchCasesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createCaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("case.name", String.valueOf(request.getCase().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings escalateCaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(escalateCaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings closeCaseTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(closeCaseMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings searchCaseClassificationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchCaseClassificationsMethodDescriptor).build();
        this.getCaseCallable = callableFactory.createUnaryCallable(getCaseTransportSettings, settings.getCaseSettings(), clientContext);
        this.listCasesCallable = callableFactory.createUnaryCallable(listCasesTransportSettings, settings.listCasesSettings(), clientContext);
        this.listCasesPagedCallable = callableFactory.createPagedCallable(listCasesTransportSettings, settings.listCasesSettings(), clientContext);
        this.searchCasesCallable = callableFactory.createUnaryCallable(searchCasesTransportSettings, settings.searchCasesSettings(), clientContext);
        this.searchCasesPagedCallable = callableFactory.createPagedCallable(searchCasesTransportSettings, settings.searchCasesSettings(), clientContext);
        this.createCaseCallable = callableFactory.createUnaryCallable(createCaseTransportSettings, settings.createCaseSettings(), clientContext);
        this.updateCaseCallable = callableFactory.createUnaryCallable(updateCaseTransportSettings, settings.updateCaseSettings(), clientContext);
        this.escalateCaseCallable = callableFactory.createUnaryCallable(escalateCaseTransportSettings, settings.escalateCaseSettings(), clientContext);
        this.closeCaseCallable = callableFactory.createUnaryCallable(closeCaseTransportSettings, settings.closeCaseSettings(), clientContext);
        this.searchCaseClassificationsCallable = callableFactory.createUnaryCallable(searchCaseClassificationsTransportSettings, settings.searchCaseClassificationsSettings(), clientContext);
        this.searchCaseClassificationsPagedCallable = callableFactory.createPagedCallable(searchCaseClassificationsTransportSettings, settings.searchCaseClassificationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCaseRequest, Case> getCaseCallable() {
        return this.getCaseCallable;
    }

    @Override
    public UnaryCallable<ListCasesRequest, ListCasesResponse> listCasesCallable() {
        return this.listCasesCallable;
    }

    @Override
    public UnaryCallable<ListCasesRequest, CaseServiceClient.ListCasesPagedResponse> listCasesPagedCallable() {
        return this.listCasesPagedCallable;
    }

    @Override
    public UnaryCallable<SearchCasesRequest, SearchCasesResponse> searchCasesCallable() {
        return this.searchCasesCallable;
    }

    @Override
    public UnaryCallable<SearchCasesRequest, CaseServiceClient.SearchCasesPagedResponse> searchCasesPagedCallable() {
        return this.searchCasesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateCaseRequest, Case> createCaseCallable() {
        return this.createCaseCallable;
    }

    @Override
    public UnaryCallable<UpdateCaseRequest, Case> updateCaseCallable() {
        return this.updateCaseCallable;
    }

    @Override
    public UnaryCallable<EscalateCaseRequest, Case> escalateCaseCallable() {
        return this.escalateCaseCallable;
    }

    @Override
    public UnaryCallable<CloseCaseRequest, Case> closeCaseCallable() {
        return this.closeCaseCallable;
    }

    @Override
    public UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsCallable() {
        return this.searchCaseClassificationsCallable;
    }

    @Override
    public UnaryCallable<SearchCaseClassificationsRequest, CaseServiceClient.SearchCaseClassificationsPagedResponse> searchCaseClassificationsPagedCallable() {
        return this.searchCaseClassificationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

