/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Case;
import com.google.cloud.support.v2.CaseClassification;
import com.google.cloud.support.v2.CaseName;
import com.google.cloud.support.v2.CaseServiceSettings;
import com.google.cloud.support.v2.CloseCaseRequest;
import com.google.cloud.support.v2.CreateCaseRequest;
import com.google.cloud.support.v2.EscalateCaseRequest;
import com.google.cloud.support.v2.GetCaseRequest;
import com.google.cloud.support.v2.ListCasesRequest;
import com.google.cloud.support.v2.ListCasesResponse;
import com.google.cloud.support.v2.OrganizationName;
import com.google.cloud.support.v2.ProjectName;
import com.google.cloud.support.v2.SearchCaseClassificationsRequest;
import com.google.cloud.support.v2.SearchCaseClassificationsResponse;
import com.google.cloud.support.v2.SearchCasesRequest;
import com.google.cloud.support.v2.SearchCasesResponse;
import com.google.cloud.support.v2.UpdateCaseRequest;
import com.google.cloud.support.v2.stub.CaseServiceStub;
import com.google.cloud.support.v2.stub.CaseServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CaseServiceClient
implements BackgroundResource {
    private final CaseServiceSettings settings;
    private final CaseServiceStub stub;

    public static final CaseServiceClient create() throws IOException {
        return CaseServiceClient.create(CaseServiceSettings.newBuilder().build());
    }

    public static final CaseServiceClient create(CaseServiceSettings settings) throws IOException {
        return new CaseServiceClient(settings);
    }

    public static final CaseServiceClient create(CaseServiceStub stub) {
        return new CaseServiceClient(stub);
    }

    protected CaseServiceClient(CaseServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CaseServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CaseServiceClient(CaseServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CaseServiceSettings getSettings() {
        return this.settings;
    }

    public CaseServiceStub getStub() {
        return this.stub;
    }

    public final Case getCase(CaseName name) {
        GetCaseRequest request = GetCaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCase(request);
    }

    public final Case getCase(String name) {
        GetCaseRequest request = GetCaseRequest.newBuilder().setName(name).build();
        return this.getCase(request);
    }

    public final Case getCase(GetCaseRequest request) {
        return (Case)this.getCaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetCaseRequest, Case> getCaseCallable() {
        return this.stub.getCaseCallable();
    }

    public final ListCasesPagedResponse listCases(OrganizationName parent) {
        ListCasesRequest request = ListCasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCases(request);
    }

    public final ListCasesPagedResponse listCases(ProjectName parent) {
        ListCasesRequest request = ListCasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCases(request);
    }

    public final ListCasesPagedResponse listCases(String parent) {
        ListCasesRequest request = ListCasesRequest.newBuilder().setParent(parent).build();
        return this.listCases(request);
    }

    public final ListCasesPagedResponse listCases(ListCasesRequest request) {
        return (ListCasesPagedResponse)((Object)this.listCasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCasesRequest, ListCasesPagedResponse> listCasesPagedCallable() {
        return this.stub.listCasesPagedCallable();
    }

    public final UnaryCallable<ListCasesRequest, ListCasesResponse> listCasesCallable() {
        return this.stub.listCasesCallable();
    }

    public final SearchCasesPagedResponse searchCases(SearchCasesRequest request) {
        return (SearchCasesPagedResponse)((Object)this.searchCasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCasesRequest, SearchCasesPagedResponse> searchCasesPagedCallable() {
        return this.stub.searchCasesPagedCallable();
    }

    public final UnaryCallable<SearchCasesRequest, SearchCasesResponse> searchCasesCallable() {
        return this.stub.searchCasesCallable();
    }

    public final Case createCase(OrganizationName parent, Case case_) {
        CreateCaseRequest request = CreateCaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCase(case_).build();
        return this.createCase(request);
    }

    public final Case createCase(ProjectName parent, Case case_) {
        CreateCaseRequest request = CreateCaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCase(case_).build();
        return this.createCase(request);
    }

    public final Case createCase(String parent, Case case_) {
        CreateCaseRequest request = CreateCaseRequest.newBuilder().setParent(parent).setCase(case_).build();
        return this.createCase(request);
    }

    public final Case createCase(CreateCaseRequest request) {
        return (Case)this.createCaseCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCaseRequest, Case> createCaseCallable() {
        return this.stub.createCaseCallable();
    }

    public final Case updateCase(Case case_, FieldMask updateMask) {
        UpdateCaseRequest request = UpdateCaseRequest.newBuilder().setCase(case_).setUpdateMask(updateMask).build();
        return this.updateCase(request);
    }

    public final Case updateCase(UpdateCaseRequest request) {
        return (Case)this.updateCaseCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCaseRequest, Case> updateCaseCallable() {
        return this.stub.updateCaseCallable();
    }

    public final Case escalateCase(EscalateCaseRequest request) {
        return (Case)this.escalateCaseCallable().call((Object)request);
    }

    public final UnaryCallable<EscalateCaseRequest, Case> escalateCaseCallable() {
        return this.stub.escalateCaseCallable();
    }

    public final Case closeCase(CloseCaseRequest request) {
        return (Case)this.closeCaseCallable().call((Object)request);
    }

    public final UnaryCallable<CloseCaseRequest, Case> closeCaseCallable() {
        return this.stub.closeCaseCallable();
    }

    public final SearchCaseClassificationsPagedResponse searchCaseClassifications(SearchCaseClassificationsRequest request) {
        return (SearchCaseClassificationsPagedResponse)((Object)this.searchCaseClassificationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsPagedResponse> searchCaseClassificationsPagedCallable() {
        return this.stub.searchCaseClassificationsPagedCallable();
    }

    public final UnaryCallable<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse> searchCaseClassificationsCallable() {
        return this.stub.searchCaseClassificationsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchCaseClassificationsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification, SearchCaseClassificationsPage, SearchCaseClassificationsFixedSizeCollection> {
        private SearchCaseClassificationsFixedSizeCollection(List<SearchCaseClassificationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCaseClassificationsFixedSizeCollection createEmptyCollection() {
            return new SearchCaseClassificationsFixedSizeCollection(null, 0);
        }

        protected SearchCaseClassificationsFixedSizeCollection createCollection(List<SearchCaseClassificationsPage> pages, int collectionSize) {
            return new SearchCaseClassificationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCaseClassificationsPage
    extends AbstractPage<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification, SearchCaseClassificationsPage> {
        private SearchCaseClassificationsPage(PageContext<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification> context, SearchCaseClassificationsResponse response) {
            super(context, (Object)response);
        }

        private static SearchCaseClassificationsPage createEmptyPage() {
            return new SearchCaseClassificationsPage(null, null);
        }

        protected SearchCaseClassificationsPage createPage(PageContext<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification> context, SearchCaseClassificationsResponse response) {
            return new SearchCaseClassificationsPage(context, response);
        }

        public ApiFuture<SearchCaseClassificationsPage> createPageAsync(PageContext<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification> context, ApiFuture<SearchCaseClassificationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCaseClassificationsPagedResponse
    extends AbstractPagedListResponse<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification, SearchCaseClassificationsPage, SearchCaseClassificationsFixedSizeCollection> {
        public static ApiFuture<SearchCaseClassificationsPagedResponse> createAsync(PageContext<SearchCaseClassificationsRequest, SearchCaseClassificationsResponse, CaseClassification> context, ApiFuture<SearchCaseClassificationsResponse> futureResponse) {
            ApiFuture<SearchCaseClassificationsPage> futurePage = SearchCaseClassificationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchCaseClassificationsPagedResponse((SearchCaseClassificationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchCaseClassificationsPagedResponse(SearchCaseClassificationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCaseClassificationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchCasesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchCasesRequest, SearchCasesResponse, Case, SearchCasesPage, SearchCasesFixedSizeCollection> {
        private SearchCasesFixedSizeCollection(List<SearchCasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchCasesFixedSizeCollection createEmptyCollection() {
            return new SearchCasesFixedSizeCollection(null, 0);
        }

        protected SearchCasesFixedSizeCollection createCollection(List<SearchCasesPage> pages, int collectionSize) {
            return new SearchCasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchCasesPage
    extends AbstractPage<SearchCasesRequest, SearchCasesResponse, Case, SearchCasesPage> {
        private SearchCasesPage(PageContext<SearchCasesRequest, SearchCasesResponse, Case> context, SearchCasesResponse response) {
            super(context, (Object)response);
        }

        private static SearchCasesPage createEmptyPage() {
            return new SearchCasesPage(null, null);
        }

        protected SearchCasesPage createPage(PageContext<SearchCasesRequest, SearchCasesResponse, Case> context, SearchCasesResponse response) {
            return new SearchCasesPage(context, response);
        }

        public ApiFuture<SearchCasesPage> createPageAsync(PageContext<SearchCasesRequest, SearchCasesResponse, Case> context, ApiFuture<SearchCasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchCasesPagedResponse
    extends AbstractPagedListResponse<SearchCasesRequest, SearchCasesResponse, Case, SearchCasesPage, SearchCasesFixedSizeCollection> {
        public static ApiFuture<SearchCasesPagedResponse> createAsync(PageContext<SearchCasesRequest, SearchCasesResponse, Case> context, ApiFuture<SearchCasesResponse> futureResponse) {
            ApiFuture<SearchCasesPage> futurePage = SearchCasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchCasesPagedResponse((SearchCasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchCasesPagedResponse(SearchCasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchCasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCasesRequest, ListCasesResponse, Case, ListCasesPage, ListCasesFixedSizeCollection> {
        private ListCasesFixedSizeCollection(List<ListCasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCasesFixedSizeCollection createEmptyCollection() {
            return new ListCasesFixedSizeCollection(null, 0);
        }

        protected ListCasesFixedSizeCollection createCollection(List<ListCasesPage> pages, int collectionSize) {
            return new ListCasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCasesPage
    extends AbstractPage<ListCasesRequest, ListCasesResponse, Case, ListCasesPage> {
        private ListCasesPage(PageContext<ListCasesRequest, ListCasesResponse, Case> context, ListCasesResponse response) {
            super(context, (Object)response);
        }

        private static ListCasesPage createEmptyPage() {
            return new ListCasesPage(null, null);
        }

        protected ListCasesPage createPage(PageContext<ListCasesRequest, ListCasesResponse, Case> context, ListCasesResponse response) {
            return new ListCasesPage(context, response);
        }

        public ApiFuture<ListCasesPage> createPageAsync(PageContext<ListCasesRequest, ListCasesResponse, Case> context, ApiFuture<ListCasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCasesPagedResponse
    extends AbstractPagedListResponse<ListCasesRequest, ListCasesResponse, Case, ListCasesPage, ListCasesFixedSizeCollection> {
        public static ApiFuture<ListCasesPagedResponse> createAsync(PageContext<ListCasesRequest, ListCasesResponse, Case> context, ApiFuture<ListCasesResponse> futureResponse) {
            ApiFuture<ListCasesPage> futurePage = ListCasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCasesPagedResponse((ListCasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCasesPagedResponse(ListCasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

