/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2beta.Comment;
import com.google.cloud.support.v2beta.CommentServiceClient;
import com.google.cloud.support.v2beta.CreateCommentRequest;
import com.google.cloud.support.v2beta.ListCommentsRequest;
import com.google.cloud.support.v2beta.ListCommentsResponse;
import com.google.cloud.support.v2beta.stub.CommentServiceStub;
import com.google.cloud.support.v2beta.stub.CommentServiceStubSettings;
import com.google.cloud.support.v2beta.stub.HttpJsonCommentServiceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCommentServiceStub
extends CommentServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListCommentsRequest, ListCommentsResponse> listCommentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2beta.CommentService/ListComments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/cases/*}/comments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta/{parent=organizations/*/cases/*}/comments"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCommentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateCommentRequest, Comment> createCommentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.support.v2beta.CommentService/CreateComment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/cases/*}/comments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2beta/{parent=organizations/*/cases/*}/comments"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("comment", (Message)request.getComment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Comment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable;
    private final UnaryCallable<ListCommentsRequest, CommentServiceClient.ListCommentsPagedResponse> listCommentsPagedCallable;
    private final UnaryCallable<CreateCommentRequest, Comment> createCommentCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCommentServiceStub create(CommentServiceStubSettings settings) throws IOException {
        return new HttpJsonCommentServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCommentServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCommentServiceStub(CommentServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCommentServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCommentServiceStub(CommentServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCommentServiceStub(CommentServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCommentServiceCallableFactory());
    }

    protected HttpJsonCommentServiceStub(CommentServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listCommentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCommentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createCommentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createCommentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.listCommentsCallable = callableFactory.createUnaryCallable(listCommentsTransportSettings, settings.listCommentsSettings(), clientContext);
        this.listCommentsPagedCallable = callableFactory.createPagedCallable(listCommentsTransportSettings, settings.listCommentsSettings(), clientContext);
        this.createCommentCallable = callableFactory.createUnaryCallable(createCommentTransportSettings, settings.createCommentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listCommentsMethodDescriptor);
        methodDescriptors.add(createCommentMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable() {
        return this.listCommentsCallable;
    }

    @Override
    public UnaryCallable<ListCommentsRequest, CommentServiceClient.ListCommentsPagedResponse> listCommentsPagedCallable() {
        return this.listCommentsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateCommentRequest, Comment> createCommentCallable() {
        return this.createCommentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

