/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2beta.CaseName;
import com.google.cloud.support.v2beta.FeedItem;
import com.google.cloud.support.v2beta.FeedServiceSettings;
import com.google.cloud.support.v2beta.ShowFeedRequest;
import com.google.cloud.support.v2beta.ShowFeedResponse;
import com.google.cloud.support.v2beta.stub.FeedServiceStub;
import com.google.cloud.support.v2beta.stub.FeedServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FeedServiceClient
implements BackgroundResource {
    private final FeedServiceSettings settings;
    private final FeedServiceStub stub;

    public static final FeedServiceClient create() throws IOException {
        return FeedServiceClient.create(FeedServiceSettings.newBuilder().build());
    }

    public static final FeedServiceClient create(FeedServiceSettings settings) throws IOException {
        return new FeedServiceClient(settings);
    }

    public static final FeedServiceClient create(FeedServiceStub stub) {
        return new FeedServiceClient(stub);
    }

    protected FeedServiceClient(FeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected FeedServiceClient(FeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedServiceSettings getSettings() {
        return this.settings;
    }

    public FeedServiceStub getStub() {
        return this.stub;
    }

    public final ShowFeedPagedResponse showFeed(CaseName parent) {
        ShowFeedRequest request = ShowFeedRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.showFeed(request);
    }

    public final ShowFeedPagedResponse showFeed(String parent) {
        ShowFeedRequest request = ShowFeedRequest.newBuilder().setParent(parent).build();
        return this.showFeed(request);
    }

    public final ShowFeedPagedResponse showFeed(ShowFeedRequest request) {
        return (ShowFeedPagedResponse)((Object)this.showFeedPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ShowFeedRequest, ShowFeedPagedResponse> showFeedPagedCallable() {
        return this.stub.showFeedPagedCallable();
    }

    public final UnaryCallable<ShowFeedRequest, ShowFeedResponse> showFeedCallable() {
        return this.stub.showFeedCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ShowFeedFixedSizeCollection
    extends AbstractFixedSizeCollection<ShowFeedRequest, ShowFeedResponse, FeedItem, ShowFeedPage, ShowFeedFixedSizeCollection> {
        private ShowFeedFixedSizeCollection(List<ShowFeedPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ShowFeedFixedSizeCollection createEmptyCollection() {
            return new ShowFeedFixedSizeCollection(null, 0);
        }

        protected ShowFeedFixedSizeCollection createCollection(List<ShowFeedPage> pages, int collectionSize) {
            return new ShowFeedFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ShowFeedPage
    extends AbstractPage<ShowFeedRequest, ShowFeedResponse, FeedItem, ShowFeedPage> {
        private ShowFeedPage(PageContext<ShowFeedRequest, ShowFeedResponse, FeedItem> context, ShowFeedResponse response) {
            super(context, (Object)response);
        }

        private static ShowFeedPage createEmptyPage() {
            return new ShowFeedPage(null, null);
        }

        protected ShowFeedPage createPage(PageContext<ShowFeedRequest, ShowFeedResponse, FeedItem> context, ShowFeedResponse response) {
            return new ShowFeedPage(context, response);
        }

        public ApiFuture<ShowFeedPage> createPageAsync(PageContext<ShowFeedRequest, ShowFeedResponse, FeedItem> context, ApiFuture<ShowFeedResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ShowFeedPagedResponse
    extends AbstractPagedListResponse<ShowFeedRequest, ShowFeedResponse, FeedItem, ShowFeedPage, ShowFeedFixedSizeCollection> {
        public static ApiFuture<ShowFeedPagedResponse> createAsync(PageContext<ShowFeedRequest, ShowFeedResponse, FeedItem> context, ApiFuture<ShowFeedResponse> futureResponse) {
            ApiFuture<ShowFeedPage> futurePage = ShowFeedPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ShowFeedPagedResponse((ShowFeedPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ShowFeedPagedResponse(ShowFeedPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ShowFeedFixedSizeCollection.createEmptyCollection());
        }
    }
}

