/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.support.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.support.v2.Comment;
import com.google.cloud.support.v2.CommentServiceClient;
import com.google.cloud.support.v2.CreateCommentRequest;
import com.google.cloud.support.v2.ListCommentsRequest;
import com.google.cloud.support.v2.ListCommentsResponse;
import com.google.cloud.support.v2.stub.CommentServiceStub;
import com.google.cloud.support.v2.stub.GrpcCommentServiceStub;
import com.google.cloud.support.v2.stub.HttpJsonCommentServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CommentServiceStubSettings
extends StubSettings<CommentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse> listCommentsSettings;
    private final UnaryCallSettings<CreateCommentRequest, Comment> createCommentSettings;
    private static final PagedListDescriptor<ListCommentsRequest, ListCommentsResponse, Comment> LIST_COMMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListCommentsRequest, ListCommentsResponse, Comment>(){

        public String emptyToken() {
            return "";
        }

        public ListCommentsRequest injectToken(ListCommentsRequest payload, String token) {
            return ListCommentsRequest.newBuilder((ListCommentsRequest)payload).setPageToken(token).build();
        }

        public ListCommentsRequest injectPageSize(ListCommentsRequest payload, int pageSize) {
            return ListCommentsRequest.newBuilder((ListCommentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCommentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCommentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Comment> extractResources(ListCommentsResponse payload) {
            return payload.getCommentsList() == null ? ImmutableList.of() : payload.getCommentsList();
        }
    };
    private static final PagedListResponseFactory<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse> LIST_COMMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse>(){

        public ApiFuture<CommentServiceClient.ListCommentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCommentsRequest, ListCommentsResponse> callable, ListCommentsRequest request, ApiCallContext context, ApiFuture<ListCommentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_COMMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CommentServiceClient.ListCommentsPagedResponse.createAsync((PageContext<ListCommentsRequest, ListCommentsResponse, Comment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse> listCommentsSettings() {
        return this.listCommentsSettings;
    }

    public UnaryCallSettings<CreateCommentRequest, Comment> createCommentSettings() {
        return this.createCommentSettings;
    }

    public CommentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCommentServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCommentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return CommentServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudsupport";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudsupport.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsupport.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CommentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CommentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CommentServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CommentServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CommentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCommentsSettings = settingsBuilder.listCommentsSettings().build();
        this.createCommentSettings = settingsBuilder.createCommentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CommentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse> listCommentsSettings;
        private final UnaryCallSettings.Builder<CreateCommentRequest, Comment> createCommentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCommentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_COMMENTS_PAGE_STR_FACT);
            this.createCommentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCommentsSettings, this.createCommentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CommentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCommentsSettings = settings.listCommentsSettings.toBuilder();
            this.createCommentSettings = settings.createCommentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCommentsSettings, this.createCommentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CommentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CommentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CommentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CommentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CommentServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CommentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CommentServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CommentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCommentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCommentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCommentsRequest, ListCommentsResponse, CommentServiceClient.ListCommentsPagedResponse> listCommentsSettings() {
            return this.listCommentsSettings;
        }

        public UnaryCallSettings.Builder<CreateCommentRequest, Comment> createCommentSettings() {
            return this.createCommentSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return CommentServiceStubSettings.getDefaultEndpoint();
        }

        public CommentServiceStubSettings build() throws IOException {
            return new CommentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

