/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlDeploymentName;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeploymentSettings;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkDeploymentName;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.OrganizationLocationName;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeploymentClient
implements BackgroundResource {
    private final DeploymentSettings settings;
    private final DeploymentStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DeploymentClient create() throws IOException {
        return DeploymentClient.create(DeploymentSettings.newBuilder().build());
    }

    public static final DeploymentClient create(DeploymentSettings settings) throws IOException {
        return new DeploymentClient(settings);
    }

    public static final DeploymentClient create(DeploymentStub stub) {
        return new DeploymentClient(stub);
    }

    protected DeploymentClient(DeploymentSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeploymentStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DeploymentClient(DeploymentStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DeploymentSettings getSettings() {
        return this.settings;
    }

    public DeploymentStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<FrameworkDeployment, OperationMetadata> createFrameworkDeploymentAsync(OrganizationLocationName parent, FrameworkDeployment frameworkDeployment, String frameworkDeploymentId) {
        CreateFrameworkDeploymentRequest request = CreateFrameworkDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFrameworkDeployment(frameworkDeployment).setFrameworkDeploymentId(frameworkDeploymentId).build();
        return this.createFrameworkDeploymentAsync(request);
    }

    public final OperationFuture<FrameworkDeployment, OperationMetadata> createFrameworkDeploymentAsync(String parent, FrameworkDeployment frameworkDeployment, String frameworkDeploymentId) {
        CreateFrameworkDeploymentRequest request = CreateFrameworkDeploymentRequest.newBuilder().setParent(parent).setFrameworkDeployment(frameworkDeployment).setFrameworkDeploymentId(frameworkDeploymentId).build();
        return this.createFrameworkDeploymentAsync(request);
    }

    public final OperationFuture<FrameworkDeployment, OperationMetadata> createFrameworkDeploymentAsync(CreateFrameworkDeploymentRequest request) {
        return this.createFrameworkDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationCallable() {
        return this.stub.createFrameworkDeploymentOperationCallable();
    }

    public final UnaryCallable<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentCallable() {
        return this.stub.createFrameworkDeploymentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFrameworkDeploymentAsync(FrameworkDeploymentName name) {
        DeleteFrameworkDeploymentRequest request = DeleteFrameworkDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFrameworkDeploymentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFrameworkDeploymentAsync(String name) {
        DeleteFrameworkDeploymentRequest request = DeleteFrameworkDeploymentRequest.newBuilder().setName(name).build();
        return this.deleteFrameworkDeploymentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFrameworkDeploymentAsync(DeleteFrameworkDeploymentRequest request) {
        return this.deleteFrameworkDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationCallable() {
        return this.stub.deleteFrameworkDeploymentOperationCallable();
    }

    public final UnaryCallable<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentCallable() {
        return this.stub.deleteFrameworkDeploymentCallable();
    }

    public final FrameworkDeployment getFrameworkDeployment(FrameworkDeploymentName name) {
        GetFrameworkDeploymentRequest request = GetFrameworkDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFrameworkDeployment(request);
    }

    public final FrameworkDeployment getFrameworkDeployment(String name) {
        GetFrameworkDeploymentRequest request = GetFrameworkDeploymentRequest.newBuilder().setName(name).build();
        return this.getFrameworkDeployment(request);
    }

    public final FrameworkDeployment getFrameworkDeployment(GetFrameworkDeploymentRequest request) {
        return (FrameworkDeployment)this.getFrameworkDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentCallable() {
        return this.stub.getFrameworkDeploymentCallable();
    }

    public final ListFrameworkDeploymentsPagedResponse listFrameworkDeployments(OrganizationLocationName parent) {
        ListFrameworkDeploymentsRequest request = ListFrameworkDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFrameworkDeployments(request);
    }

    public final ListFrameworkDeploymentsPagedResponse listFrameworkDeployments(String parent) {
        ListFrameworkDeploymentsRequest request = ListFrameworkDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listFrameworkDeployments(request);
    }

    public final ListFrameworkDeploymentsPagedResponse listFrameworkDeployments(ListFrameworkDeploymentsRequest request) {
        return (ListFrameworkDeploymentsPagedResponse)((Object)this.listFrameworkDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsPagedCallable() {
        return this.stub.listFrameworkDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsCallable() {
        return this.stub.listFrameworkDeploymentsCallable();
    }

    public final CloudControlDeployment getCloudControlDeployment(CloudControlDeploymentName name) {
        GetCloudControlDeploymentRequest request = GetCloudControlDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloudControlDeployment(request);
    }

    public final CloudControlDeployment getCloudControlDeployment(String name) {
        GetCloudControlDeploymentRequest request = GetCloudControlDeploymentRequest.newBuilder().setName(name).build();
        return this.getCloudControlDeployment(request);
    }

    public final CloudControlDeployment getCloudControlDeployment(GetCloudControlDeploymentRequest request) {
        return (CloudControlDeployment)this.getCloudControlDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentCallable() {
        return this.stub.getCloudControlDeploymentCallable();
    }

    public final ListCloudControlDeploymentsPagedResponse listCloudControlDeployments(OrganizationLocationName parent) {
        ListCloudControlDeploymentsRequest request = ListCloudControlDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloudControlDeployments(request);
    }

    public final ListCloudControlDeploymentsPagedResponse listCloudControlDeployments(String parent) {
        ListCloudControlDeploymentsRequest request = ListCloudControlDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listCloudControlDeployments(request);
    }

    public final ListCloudControlDeploymentsPagedResponse listCloudControlDeployments(ListCloudControlDeploymentsRequest request) {
        return (ListCloudControlDeploymentsPagedResponse)((Object)this.listCloudControlDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsPagedCallable() {
        return this.stub.listCloudControlDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsCallable() {
        return this.stub.listCloudControlDeploymentsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloudControlDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment, ListCloudControlDeploymentsPage, ListCloudControlDeploymentsFixedSizeCollection> {
        private ListCloudControlDeploymentsFixedSizeCollection(List<ListCloudControlDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloudControlDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListCloudControlDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListCloudControlDeploymentsFixedSizeCollection createCollection(List<ListCloudControlDeploymentsPage> pages, int collectionSize) {
            return new ListCloudControlDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloudControlDeploymentsPage
    extends AbstractPage<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment, ListCloudControlDeploymentsPage> {
        private ListCloudControlDeploymentsPage(PageContext<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment> context, ListCloudControlDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListCloudControlDeploymentsPage createEmptyPage() {
            return new ListCloudControlDeploymentsPage(null, null);
        }

        protected ListCloudControlDeploymentsPage createPage(PageContext<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment> context, ListCloudControlDeploymentsResponse response) {
            return new ListCloudControlDeploymentsPage(context, response);
        }

        public ApiFuture<ListCloudControlDeploymentsPage> createPageAsync(PageContext<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment> context, ApiFuture<ListCloudControlDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloudControlDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment, ListCloudControlDeploymentsPage, ListCloudControlDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListCloudControlDeploymentsPagedResponse> createAsync(PageContext<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse, CloudControlDeployment> context, ApiFuture<ListCloudControlDeploymentsResponse> futureResponse) {
            ApiFuture<ListCloudControlDeploymentsPage> futurePage = ListCloudControlDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloudControlDeploymentsPagedResponse((ListCloudControlDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloudControlDeploymentsPagedResponse(ListCloudControlDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloudControlDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFrameworkDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment, ListFrameworkDeploymentsPage, ListFrameworkDeploymentsFixedSizeCollection> {
        private ListFrameworkDeploymentsFixedSizeCollection(List<ListFrameworkDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFrameworkDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListFrameworkDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListFrameworkDeploymentsFixedSizeCollection createCollection(List<ListFrameworkDeploymentsPage> pages, int collectionSize) {
            return new ListFrameworkDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFrameworkDeploymentsPage
    extends AbstractPage<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment, ListFrameworkDeploymentsPage> {
        private ListFrameworkDeploymentsPage(PageContext<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment> context, ListFrameworkDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListFrameworkDeploymentsPage createEmptyPage() {
            return new ListFrameworkDeploymentsPage(null, null);
        }

        protected ListFrameworkDeploymentsPage createPage(PageContext<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment> context, ListFrameworkDeploymentsResponse response) {
            return new ListFrameworkDeploymentsPage(context, response);
        }

        public ApiFuture<ListFrameworkDeploymentsPage> createPageAsync(PageContext<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment> context, ApiFuture<ListFrameworkDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFrameworkDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment, ListFrameworkDeploymentsPage, ListFrameworkDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListFrameworkDeploymentsPagedResponse> createAsync(PageContext<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse, FrameworkDeployment> context, ApiFuture<ListFrameworkDeploymentsResponse> futureResponse) {
            ApiFuture<ListFrameworkDeploymentsPage> futurePage = ListFrameworkDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFrameworkDeploymentsPagedResponse((ListFrameworkDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFrameworkDeploymentsPagedResponse(ListFrameworkDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFrameworkDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

