/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CloudControlDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeleteFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.DeploymentClient;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkDeployment;
import com.google.cloud.cloudsecuritycompliance.v1.GetCloudControlDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkDeploymentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListCloudControlDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkDeploymentsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.DeploymentStubSettings;
import com.google.cloud.cloudsecuritycompliance.v1.stub.GrpcDeploymentCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDeploymentStub
extends DeploymentStub {
    private static final MethodDescriptor<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/CreateFrameworkDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFrameworkDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/DeleteFrameworkDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFrameworkDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/GetFrameworkDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFrameworkDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FrameworkDeployment.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/ListFrameworkDeployments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFrameworkDeploymentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFrameworkDeploymentsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/GetCloudControlDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCloudControlDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CloudControlDeployment.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.cloudsecuritycompliance.v1.Deployment/ListCloudControlDeployments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCloudControlDeploymentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCloudControlDeploymentsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentCallable;
    private final OperationCallable<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationCallable;
    private final UnaryCallable<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentCallable;
    private final OperationCallable<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationCallable;
    private final UnaryCallable<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentCallable;
    private final UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsCallable;
    private final UnaryCallable<ListFrameworkDeploymentsRequest, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsPagedCallable;
    private final UnaryCallable<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentCallable;
    private final UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsCallable;
    private final UnaryCallable<ListCloudControlDeploymentsRequest, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DeploymentClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDeploymentStub create(DeploymentStubSettings settings) throws IOException {
        return new GrpcDeploymentStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDeploymentStub create(ClientContext clientContext) throws IOException {
        return new GrpcDeploymentStub(DeploymentStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDeploymentStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDeploymentStub(DeploymentStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDeploymentStub(DeploymentStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDeploymentCallableFactory());
    }

    protected GrpcDeploymentStub(DeploymentStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createFrameworkDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFrameworkDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFrameworkDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFrameworkDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getFrameworkDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFrameworkDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listFrameworkDeploymentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFrameworkDeploymentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCloudControlDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCloudControlDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listCloudControlDeploymentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCloudControlDeploymentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createFrameworkDeploymentCallable = callableFactory.createUnaryCallable(createFrameworkDeploymentTransportSettings, settings.createFrameworkDeploymentSettings(), clientContext);
        this.createFrameworkDeploymentOperationCallable = callableFactory.createOperationCallable(createFrameworkDeploymentTransportSettings, settings.createFrameworkDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteFrameworkDeploymentCallable = callableFactory.createUnaryCallable(deleteFrameworkDeploymentTransportSettings, settings.deleteFrameworkDeploymentSettings(), clientContext);
        this.deleteFrameworkDeploymentOperationCallable = callableFactory.createOperationCallable(deleteFrameworkDeploymentTransportSettings, settings.deleteFrameworkDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getFrameworkDeploymentCallable = callableFactory.createUnaryCallable(getFrameworkDeploymentTransportSettings, settings.getFrameworkDeploymentSettings(), clientContext);
        this.listFrameworkDeploymentsCallable = callableFactory.createUnaryCallable(listFrameworkDeploymentsTransportSettings, settings.listFrameworkDeploymentsSettings(), clientContext);
        this.listFrameworkDeploymentsPagedCallable = callableFactory.createPagedCallable(listFrameworkDeploymentsTransportSettings, settings.listFrameworkDeploymentsSettings(), clientContext);
        this.getCloudControlDeploymentCallable = callableFactory.createUnaryCallable(getCloudControlDeploymentTransportSettings, settings.getCloudControlDeploymentSettings(), clientContext);
        this.listCloudControlDeploymentsCallable = callableFactory.createUnaryCallable(listCloudControlDeploymentsTransportSettings, settings.listCloudControlDeploymentsSettings(), clientContext);
        this.listCloudControlDeploymentsPagedCallable = callableFactory.createPagedCallable(listCloudControlDeploymentsTransportSettings, settings.listCloudControlDeploymentsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateFrameworkDeploymentRequest, Operation> createFrameworkDeploymentCallable() {
        return this.createFrameworkDeploymentCallable;
    }

    @Override
    public OperationCallable<CreateFrameworkDeploymentRequest, FrameworkDeployment, OperationMetadata> createFrameworkDeploymentOperationCallable() {
        return this.createFrameworkDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFrameworkDeploymentRequest, Operation> deleteFrameworkDeploymentCallable() {
        return this.deleteFrameworkDeploymentCallable;
    }

    @Override
    public OperationCallable<DeleteFrameworkDeploymentRequest, Empty, OperationMetadata> deleteFrameworkDeploymentOperationCallable() {
        return this.deleteFrameworkDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<GetFrameworkDeploymentRequest, FrameworkDeployment> getFrameworkDeploymentCallable() {
        return this.getFrameworkDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListFrameworkDeploymentsRequest, ListFrameworkDeploymentsResponse> listFrameworkDeploymentsCallable() {
        return this.listFrameworkDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListFrameworkDeploymentsRequest, DeploymentClient.ListFrameworkDeploymentsPagedResponse> listFrameworkDeploymentsPagedCallable() {
        return this.listFrameworkDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudControlDeploymentRequest, CloudControlDeployment> getCloudControlDeploymentCallable() {
        return this.getCloudControlDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlDeploymentsRequest, ListCloudControlDeploymentsResponse> listCloudControlDeploymentsCallable() {
        return this.listCloudControlDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListCloudControlDeploymentsRequest, DeploymentClient.ListCloudControlDeploymentsPagedResponse> listCloudControlDeploymentsPagedCallable() {
        return this.listCloudControlDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DeploymentClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

