/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.AuditClient;
import com.google.cloud.cloudsecuritycompliance.v1.CreateFrameworkAuditRequest;
import com.google.cloud.cloudsecuritycompliance.v1.FrameworkAudit;
import com.google.cloud.cloudsecuritycompliance.v1.GenerateFrameworkAuditScopeReportRequest;
import com.google.cloud.cloudsecuritycompliance.v1.GenerateFrameworkAuditScopeReportResponse;
import com.google.cloud.cloudsecuritycompliance.v1.GetFrameworkAuditRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkAuditsRequest;
import com.google.cloud.cloudsecuritycompliance.v1.ListFrameworkAuditsResponse;
import com.google.cloud.cloudsecuritycompliance.v1.OperationMetadata;
import com.google.cloud.cloudsecuritycompliance.v1.stub.AuditStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.GrpcAuditStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.HttpJsonAuditStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AuditStubSettings
extends StubSettings<AuditStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GenerateFrameworkAuditScopeReportRequest, GenerateFrameworkAuditScopeReportResponse> generateFrameworkAuditScopeReportSettings;
    private final UnaryCallSettings<CreateFrameworkAuditRequest, Operation> createFrameworkAuditSettings;
    private final OperationCallSettings<CreateFrameworkAuditRequest, FrameworkAudit, OperationMetadata> createFrameworkAuditOperationSettings;
    private final PagedCallSettings<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse> listFrameworkAuditsSettings;
    private final UnaryCallSettings<GetFrameworkAuditRequest, FrameworkAudit> getFrameworkAuditSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit> LIST_FRAMEWORK_AUDITS_PAGE_STR_DESC = new PagedListDescriptor<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit>(){

        public String emptyToken() {
            return "";
        }

        public ListFrameworkAuditsRequest injectToken(ListFrameworkAuditsRequest payload, String token) {
            return ListFrameworkAuditsRequest.newBuilder((ListFrameworkAuditsRequest)payload).setPageToken(token).build();
        }

        public ListFrameworkAuditsRequest injectPageSize(ListFrameworkAuditsRequest payload, int pageSize) {
            return ListFrameworkAuditsRequest.newBuilder((ListFrameworkAuditsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFrameworkAuditsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFrameworkAuditsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FrameworkAudit> extractResources(ListFrameworkAuditsResponse payload) {
            return payload.getFrameworkAuditsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse> LIST_FRAMEWORK_AUDITS_PAGE_STR_FACT = new PagedListResponseFactory<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse>(){

        public ApiFuture<AuditClient.ListFrameworkAuditsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse> callable, ListFrameworkAuditsRequest request, ApiCallContext context, ApiFuture<ListFrameworkAuditsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FRAMEWORK_AUDITS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AuditClient.ListFrameworkAuditsPagedResponse.createAsync((PageContext<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, FrameworkAudit>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse>(){

        public ApiFuture<AuditClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AuditClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GenerateFrameworkAuditScopeReportRequest, GenerateFrameworkAuditScopeReportResponse> generateFrameworkAuditScopeReportSettings() {
        return this.generateFrameworkAuditScopeReportSettings;
    }

    public UnaryCallSettings<CreateFrameworkAuditRequest, Operation> createFrameworkAuditSettings() {
        return this.createFrameworkAuditSettings;
    }

    public OperationCallSettings<CreateFrameworkAuditRequest, FrameworkAudit, OperationMetadata> createFrameworkAuditOperationSettings() {
        return this.createFrameworkAuditOperationSettings;
    }

    public PagedCallSettings<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse> listFrameworkAuditsSettings() {
        return this.listFrameworkAuditsSettings;
    }

    public UnaryCallSettings<GetFrameworkAuditRequest, FrameworkAudit> getFrameworkAuditSettings() {
        return this.getFrameworkAuditSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public AuditStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAuditStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAuditStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudsecuritycompliance";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudsecuritycompliance.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudsecuritycompliance.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AuditStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuditStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuditStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AuditStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AuditStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateFrameworkAuditScopeReportSettings = settingsBuilder.generateFrameworkAuditScopeReportSettings().build();
        this.createFrameworkAuditSettings = settingsBuilder.createFrameworkAuditSettings().build();
        this.createFrameworkAuditOperationSettings = settingsBuilder.createFrameworkAuditOperationSettings().build();
        this.listFrameworkAuditsSettings = settingsBuilder.listFrameworkAuditsSettings().build();
        this.getFrameworkAuditSettings = settingsBuilder.getFrameworkAuditSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AuditStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GenerateFrameworkAuditScopeReportRequest, GenerateFrameworkAuditScopeReportResponse> generateFrameworkAuditScopeReportSettings;
        private final UnaryCallSettings.Builder<CreateFrameworkAuditRequest, Operation> createFrameworkAuditSettings;
        private final OperationCallSettings.Builder<CreateFrameworkAuditRequest, FrameworkAudit, OperationMetadata> createFrameworkAuditOperationSettings;
        private final PagedCallSettings.Builder<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse> listFrameworkAuditsSettings;
        private final UnaryCallSettings.Builder<GetFrameworkAuditRequest, FrameworkAudit> getFrameworkAuditSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateFrameworkAuditScopeReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFrameworkAuditSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFrameworkAuditOperationSettings = OperationCallSettings.newBuilder();
            this.listFrameworkAuditsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FRAMEWORK_AUDITS_PAGE_STR_FACT);
            this.getFrameworkAuditSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateFrameworkAuditScopeReportSettings, this.createFrameworkAuditSettings, this.listFrameworkAuditsSettings, this.getFrameworkAuditSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AuditStubSettings settings) {
            super((StubSettings)settings);
            this.generateFrameworkAuditScopeReportSettings = settings.generateFrameworkAuditScopeReportSettings.toBuilder();
            this.createFrameworkAuditSettings = settings.createFrameworkAuditSettings.toBuilder();
            this.createFrameworkAuditOperationSettings = settings.createFrameworkAuditOperationSettings.toBuilder();
            this.listFrameworkAuditsSettings = settings.listFrameworkAuditsSettings.toBuilder();
            this.getFrameworkAuditSettings = settings.getFrameworkAuditSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateFrameworkAuditScopeReportSettings, this.createFrameworkAuditSettings, this.listFrameworkAuditsSettings, this.getFrameworkAuditSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AuditStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AuditStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuditStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AuditStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AuditStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AuditStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuditStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AuditStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateFrameworkAuditScopeReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createFrameworkAuditSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listFrameworkAuditsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFrameworkAuditSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createFrameworkAuditOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FrameworkAudit.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GenerateFrameworkAuditScopeReportRequest, GenerateFrameworkAuditScopeReportResponse> generateFrameworkAuditScopeReportSettings() {
            return this.generateFrameworkAuditScopeReportSettings;
        }

        public UnaryCallSettings.Builder<CreateFrameworkAuditRequest, Operation> createFrameworkAuditSettings() {
            return this.createFrameworkAuditSettings;
        }

        public OperationCallSettings.Builder<CreateFrameworkAuditRequest, FrameworkAudit, OperationMetadata> createFrameworkAuditOperationSettings() {
            return this.createFrameworkAuditOperationSettings;
        }

        public PagedCallSettings.Builder<ListFrameworkAuditsRequest, ListFrameworkAuditsResponse, AuditClient.ListFrameworkAuditsPagedResponse> listFrameworkAuditsSettings() {
            return this.listFrameworkAuditsSettings;
        }

        public UnaryCallSettings.Builder<GetFrameworkAuditRequest, FrameworkAudit> getFrameworkAuditSettings() {
            return this.getFrameworkAuditSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AuditClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public AuditStubSettings build() throws IOException {
            return new AuditStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

